/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.activity;

import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.home.activity.entity.Activity;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.page.activity.Action;
import com.dianping.cat.report.page.activity.Context;
import com.dianping.cat.report.page.activity.Handler;
import com.dianping.cat.report.page.activity.JspViewer;
import com.dianping.cat.report.page.activity.Model;
import com.dianping.cat.report.page.activity.Payload;
import com.dianping.cat.report.page.activity.config.ActivityConfigManager;
import com.dianping.cat.report.page.transaction.transform.TransactionMergeHelper;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private ActivityConfigManager m_configManager;
    @Inject
    private TransactionMergeHelper m_mergeHelper;
    @Inject(type=ModelService.class, value={"transaction"})
    private ModelService<TransactionReport> m_service;
    private LinkedHashMap<String, TransactionReport> m_reports = new /* Unavailable Anonymous Inner Class!! */;

    public List<LineChart> buildLineChart(Activity activity, Date start, Date end) {
        String type = activity.getType();
        String name = activity.getName();
        int size = (int)((end.getTime() - start.getTime()) / 60000L);
        LineChart countChart = new LineChart().setTitle("count (minute)").setStep(60000L).setId(type + "_" + name + "_qps").setSize(size).setStart(start);
        LineChart avgChart = new LineChart().setTitle("response time(ms)").setStep(60000L).setId(type + "_" + name + "_avg").setSize(size).setStart(start);
        ArrayList<LineChart> charts = new ArrayList<LineChart>();
        Double[] allCounts = new Double[size];
        Double[] allAvgs = new Double[size];
        int index = 0;
        for (long current = start.getTime(); current < end.getTime(); current += 3600000L) {
            TransactionReport report = this.fetchReport(activity, current);
            TransactionReportVisitor visitor = null;
            report = this.m_mergeHelper.mergeAllMachines(report, "All");
            if (StringUtils.isEmpty((String)name)) {
                report = this.m_mergeHelper.mergeAllNames(report, "All");
                visitor = new TransactionReportVisitor(this, type, "All");
            } else {
                visitor = new TransactionReportVisitor(this, type, name);
            }
            visitor.visitTransactionReport(report);
            Double[] counts = visitor.getCount();
            Double[] avgs = visitor.getAvg();
            int i = 0;
            while (i < 60) {
                allCounts[index] = counts[i];
                allAvgs[index] = avgs[i];
                ++i;
                ++index;
            }
        }
        int max = 0;
        for (int i = 0; i < allCounts.length; ++i) {
            if (allCounts[i] != null) continue;
            max = i;
            break;
        }
        if (max > 1) {
            allCounts[max - 1] = null;
            allAvgs[max - 1] = null;
        }
        countChart.add("qps", allCounts);
        avgChart.add("avg", allAvgs);
        charts.add(countChart);
        charts.add(avgChart);
        return charts;
    }

    private TransactionReport fetchReport(Activity activity, long time) {
        TransactionReport report;
        String domain = activity.getDomain();
        String type = activity.getType();
        String name = activity.getName();
        if (name == null || name.length() == 0) {
            name = "*";
        }
        ModelPeriod period = ModelPeriod.getByTime((long)time);
        String key = String.valueOf(time) + ":" + domain;
        if (period.isHistorical() && (report = (TransactionReport)this.m_reports.get(key)) != null) {
            return report;
        }
        ModelRequest request = new ModelRequest(domain, time).setProperty("type", type).setProperty("name", name);
        ModelResponse response = this.m_service.invoke(request);
        TransactionReport report2 = (TransactionReport)response.getModel();
        if (period.isHistorical() && report2 != null) {
            this.m_reports.put(key, report2);
        }
        return report2;
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="activity")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="activity")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Date start = payload.getStartDate();
        Date end = payload.getEndDate();
        List activities = this.m_configManager.getActivityConfig().getActivities();
        LinkedHashMap<String, List> chartsMap = new LinkedHashMap<String, List>();
        for (Activity activity : activities) {
            List charts = this.buildLineChart(activity, start, end);
            chartsMap.put(activity.getTitle(), charts);
        }
        model.setCharts(chartsMap);
        model.setStart(start);
        model.setEnd(end);
        model.setAction((org.unidal.web.mvc.Action)Action.VIEW);
        model.setPage((Page)ReportPage.ACTIVITY);
        if (!ctx.isProcessStopped()) {
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }
}

