/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.activity;

import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.activity.Action;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.payload.annotation.FieldMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Payload
extends AbstractReportPayload<Action, ReportPage> {
    private ReportPage m_page;
    @FieldMeta(value="op")
    private Action m_action;
    @FieldMeta(value="startTime")
    private String m_startTime;
    @FieldMeta(value="endTime")
    private String m_endTime;

    public Payload() {
        super((Page)ReportPage.ACTIVITY);
    }

    public Action getAction() {
        return this.m_action;
    }

    public Date getEndDate() {
        if (this.m_endTime != null) {
            return this.parseDate(this.m_endTime);
        }
        return TimeHelper.getCurrentHour((int)1);
    }

    public ReportPage getPage() {
        return this.m_page;
    }

    public Date getStartDate() {
        if (this.m_startTime != null) {
            return this.parseDate(this.m_startTime);
        }
        return TimeHelper.getCurrentHour((int)-1);
    }

    public Date parseDate(String date) {
        Date d = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            d = sdf.parse(date);
        }
        catch (Exception e) {
            d = new Date();
        }
        if (d.getTime() > System.currentTimeMillis()) {
            d = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public void setAction(String action) {
        this.m_action = Action.getByName((String)action, (Action)Action.VIEW);
    }

    public void setEndTime(String endTime) {
        this.m_endTime = endTime;
    }

    public void setPage(String page) {
        this.m_page = ReportPage.getByName((String)page, (ReportPage)ReportPage.ACTIVITY);
    }

    public void setStartTime(String startTime) {
        this.m_startTime = startTime;
    }

    public void validate(ActionContext<?> ctx) {
        if (this.m_action == null) {
            this.m_action = Action.VIEW;
        }
    }
}

