/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.alert;

import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.alert.Action;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.unidal.helper.Splitters;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.ActionPayload;
import org.unidal.web.mvc.payload.annotation.FieldMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Payload
implements ActionPayload<ReportPage, Action> {
    private ReportPage m_page;
    @FieldMeta(value="channel")
    private String m_channel;
    @FieldMeta(value="title")
    private String m_title;
    @FieldMeta(value="content")
    private String m_content;
    @FieldMeta(value="group")
    private String m_group;
    @FieldMeta(value="domain")
    private String m_domain;
    @FieldMeta(value="startTime")
    private String m_startTime;
    @FieldMeta(value="endTime")
    private String m_endTime;
    @FieldMeta(value="frequency")
    private int m_frequency = 10;
    @FieldMeta(value="fullScreen")
    private boolean m_fullScreen = false;
    @FieldMeta(value="refresh")
    private boolean m_refresh = false;
    @FieldMeta(value="type")
    private String m_type;
    @FieldMeta(value="op")
    private Action m_action;
    @FieldMeta(value="receivers")
    private String m_receivers;
    @FieldMeta(value="reportType")
    private String m_reportType = "";
    @FieldMeta(value="alertType")
    private String m_alertType = "";
    @FieldMeta(value="alertTime")
    private String m_alertTime;
    @FieldMeta(value="category")
    private String m_category;
    @FieldMeta(value="level")
    private String m_level;
    @FieldMeta(value="metric")
    private String m_metric;
    @FieldMeta(value="count")
    private int m_count;
    private DateFormat m_format = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public Action getAction() {
        return this.m_action;
    }

    public Date getAlertTime() {
        try {
            return this.m_format.parse(this.m_alertTime);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public String getAlertType() {
        return this.m_alertType;
    }

    public String[] getAlertTypeArray() {
        List typeList = Splitters.by((String)",").noEmptyItem().split(this.m_alertType);
        String[] typeArray = new String[typeList.size()];
        return typeList.toArray(typeArray);
    }

    public String getCategory() {
        if (StringUtils.isEmpty((String)this.m_category)) {
            return "zabbix";
        }
        return this.m_category;
    }

    public String getChannel() {
        if (StringUtils.isEmpty((String)this.m_channel)) {
            return "";
        }
        return this.m_channel;
    }

    public String getContent() {
        if (StringUtils.isEmpty((String)this.m_content)) {
            return "";
        }
        return this.m_content;
    }

    public int getCount() {
        if (this.m_count == 0) {
            return 10;
        }
        return this.m_count;
    }

    public String getDomain() {
        if (StringUtils.isEmpty((String)this.m_domain)) {
            return null;
        }
        return this.m_domain;
    }

    public Date getEndTime() {
        try {
            return this.m_format.parse(this.m_endTime);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public int getFrequency() {
        return this.m_frequency;
    }

    public String getGroup() {
        if (StringUtils.isEmpty((String)this.m_group)) {
            return "default";
        }
        return this.m_group;
    }

    public String getLevel() {
        if (StringUtils.isEmpty((String)this.m_level)) {
            return "warning";
        }
        return this.m_level;
    }

    public String getMetric() {
        if (StringUtils.isEmpty((String)this.m_metric)) {
            return "";
        }
        return this.m_metric;
    }

    public ReportPage getPage() {
        return this.m_page;
    }

    public String getReceivers() {
        if (StringUtils.isEmpty((String)this.m_receivers)) {
            return "";
        }
        return this.m_receivers;
    }

    public String getReportType() {
        return this.m_reportType;
    }

    public Date getStartTime() {
        try {
            return this.m_format.parse(this.m_startTime);
        }
        catch (Exception e) {
            return new Date(System.currentTimeMillis() - 900000L);
        }
    }

    public String getTitle() {
        if (StringUtils.isEmpty((String)this.m_title)) {
            return "";
        }
        return this.m_title;
    }

    public String getType() {
        if (StringUtils.isEmpty((String)this.m_type)) {
            return "call";
        }
        return this.m_type;
    }

    public boolean isFullScreen() {
        return this.m_fullScreen;
    }

    public boolean isRefresh() {
        return this.m_refresh;
    }

    public void setAction(String action) {
        this.m_action = Action.getByName((String)action, (Action)Action.VIEW);
    }

    public void setAlertTime(String alertTime) {
        this.m_alertTime = alertTime;
    }

    public void setAlertType(String alertType) {
        this.m_alertType = alertType;
    }

    public void setCategory(String category) {
        this.m_category = category;
    }

    public void setChannel(String channel) {
        this.m_channel = channel;
    }

    public void setContent(String content) {
        this.m_content = content;
    }

    public void setCount(int count) {
        this.m_count = count;
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public void setEndTime(String endTime) {
        this.m_endTime = endTime;
    }

    public void setFrequency(int frequency) {
        this.m_frequency = frequency;
    }

    public void setFullScreen(boolean fullScreen) {
        this.m_fullScreen = fullScreen;
    }

    public void setGroup(String group) {
        this.m_group = group;
    }

    public void setLevel(String level) {
        this.m_level = level;
    }

    public void setMetric(String metric) {
        this.m_metric = metric;
    }

    public void setPage(String page) {
        this.m_page = ReportPage.getByName((String)page, (ReportPage)ReportPage.ALERT);
    }

    public void setReceivers(String receivers) {
        this.m_receivers = receivers;
    }

    public void setRefresh(boolean refresh) {
        this.m_refresh = refresh;
    }

    public void setReportType(String reportType) {
        this.m_reportType = "";
    }

    public void setStartTime(String startTime) {
        this.m_startTime = startTime;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void validate(ActionContext<?> ctx) {
        if (this.m_action == null) {
            this.m_action = Action.ALERT;
        }
    }
}

