/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.alteration;

import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.alteration.Action;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.payload.annotation.FieldMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Payload
extends AbstractReportPayload<Action, ReportPage> {
    private ReportPage m_page;
    @FieldMeta(value="altType")
    private String m_altType;
    @FieldMeta(value="group")
    private String m_group;
    @FieldMeta(value="op")
    private Action m_action;
    @FieldMeta(value="type")
    private String m_type;
    @FieldMeta(value="title")
    private String m_title;
    @FieldMeta(value="domain")
    private String m_domain;
    @FieldMeta(value="ip")
    private String m_ip;
    @FieldMeta(value="alterationDate")
    private String m_alterationDate;
    @FieldMeta(value="user")
    private String m_user;
    @FieldMeta(value="content")
    private String m_content;
    @FieldMeta(value="url")
    private String m_url;
    @FieldMeta(value="startTime")
    private String m_startTime;
    @FieldMeta(value="endTime")
    private String m_endTime;
    @FieldMeta(value="hostname")
    private String m_hostname;
    @FieldMeta(value="count")
    private int m_count;
    @FieldMeta(value="status")
    private int m_status;
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private SimpleDateFormat m_secondFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public Payload() {
        super((Page)ReportPage.ALTERATION);
    }

    public Action getAction() {
        if (this.m_action == null) {
            return Action.VIEW;
        }
        return this.m_action;
    }

    public Date getAlterationDate() {
        try {
            if (this.m_alterationDate.length() == 16) {
                return this.m_sdf.parse(this.m_alterationDate);
            }
            return this.m_secondFormat.parse(this.m_alterationDate);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public String getAltType() {
        return this.m_altType;
    }

    public String[] getAltTypeArray() {
        if (StringUtils.isEmpty((String)this.m_altType)) {
            return null;
        }
        return this.m_altType.split(",");
    }

    public String getContent() {
        return this.m_content;
    }

    public int getCount() {
        if (this.m_count == 0) {
            return 10;
        }
        return this.m_count;
    }

    public String getDomain() {
        if (this.m_domain == null || "".equals(this.m_domain)) {
            return null;
        }
        return this.m_domain;
    }

    public Date getEndTime() {
        if (this.m_endTime == null || this.m_endTime.length() == 0) {
            return new Date();
        }
        try {
            return this.m_sdf.parse(this.m_endTime);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getHostname() {
        if (this.m_hostname == null || "".equals(this.m_hostname)) {
            return null;
        }
        return this.m_hostname;
    }

    public String getIp() {
        return this.m_ip;
    }

    public ReportPage getPage() {
        return this.m_page;
    }

    public Date getStartTime() {
        if (this.m_startTime == null || this.m_startTime.length() == 0) {
            return new Date(System.currentTimeMillis() - 900000L);
        }
        try {
            return this.m_sdf.parse(this.m_startTime);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getTitle() {
        if (this.m_title != null && this.m_title.length() > 128) {
            this.m_title = this.m_title.substring(0, 128);
        }
        return this.m_title;
    }

    public String getType() {
        return this.m_type;
    }

    public String getUrl() {
        return this.m_url;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setAction(String action) {
        this.m_action = Action.getByName((String)action, (Action)Action.VIEW);
    }

    public void setAlterationDate(String alterationDate) {
        this.m_alterationDate = alterationDate;
    }

    public void setAltType(String altType) {
        this.m_altType = altType;
    }

    public void setContent(String content) {
        this.m_content = content;
    }

    public void setCount(int count) {
        this.m_count = count;
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public void setEndTime(String endTime) {
        this.m_endTime = endTime;
    }

    public void setGroup(String group) {
        this.m_group = group;
    }

    public void setHostname(String hostname) {
        this.m_hostname = hostname;
    }

    public void setIp(String ip) {
        this.m_ip = ip;
    }

    public void setPage(ReportPage page) {
        this.m_page = page;
    }

    public void setPage(String page) {
        this.m_page = ReportPage.getByName((String)page, (ReportPage)ReportPage.ALTERATION);
    }

    public void setStartTime(String startTime) {
        this.m_startTime = startTime;
    }

    public void setStatus(int status) {
        this.m_status = status;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public void validate(ActionContext<?> ctx) {
        if (this.m_action == null) {
            this.m_action = Action.VIEW;
        }
    }
}

