/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app;

import com.dianping.cat.Cat;
import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.config.app.AppSpeedConfigManager;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.configuration.app.speed.entity.Speed;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.app.entity.AppReport;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.alert.app.AppRuleConfigManager;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.PieChart;
import com.dianping.cat.report.page.app.Action;
import com.dianping.cat.report.page.app.Context;
import com.dianping.cat.report.page.app.Handler;
import com.dianping.cat.report.page.app.JspViewer;
import com.dianping.cat.report.page.app.Model;
import com.dianping.cat.report.page.app.Payload;
import com.dianping.cat.report.page.app.display.AppCommandsSorter;
import com.dianping.cat.report.page.app.display.AppConnectionGraphCreator;
import com.dianping.cat.report.page.app.display.AppDataDetail;
import com.dianping.cat.report.page.app.display.AppGraphCreator;
import com.dianping.cat.report.page.app.display.AppSpeedDisplayInfo;
import com.dianping.cat.report.page.app.display.ChartSorter;
import com.dianping.cat.report.page.app.display.CodeDisplayVisitor;
import com.dianping.cat.report.page.app.display.DisplayCommands;
import com.dianping.cat.report.page.app.display.PieChartDetailInfo;
import com.dianping.cat.report.page.app.processor.CrashLogProcessor;
import com.dianping.cat.report.page.app.service.AppConnectionService;
import com.dianping.cat.report.page.app.service.AppDataField;
import com.dianping.cat.report.page.app.service.AppDataService;
import com.dianping.cat.report.page.app.service.AppReportService;
import com.dianping.cat.report.page.app.service.AppSpeedService;
import com.dianping.cat.report.page.app.service.CommandQueryEntity;
import com.dianping.cat.report.page.app.service.SpeedQueryEntity;
import com.dianping.cat.service.ProjectService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private AppConfigManager m_appConfigManager;
    @Inject
    private AppSpeedConfigManager m_appSpeedConfigManager;
    @Inject
    private AppGraphCreator m_appGraphCreator;
    @Inject
    private AppDataService m_appDataService;
    @Inject
    private AppSpeedService m_appSpeedService;
    @Inject
    private AppConnectionGraphCreator m_appConnectionGraphCreator;
    @Inject
    private AppConnectionService m_appConnectionService;
    @Inject
    private AppRuleConfigManager m_appRuleConfigManager;
    @Inject
    private CrashLogProcessor m_crashLogProcessor;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private AppReportService m_appReportService;
    @Inject
    private ProjectService m_projectService;

    private List<AppDataDetail> buildAppDataDetails(Payload payload) {
        List<Object> appDetails = new ArrayList<AppDataDetail>();
        try {
            appDetails = this.m_appDataService.buildAppDataDetailInfos(payload.getQueryEntity1(), payload.getGroupByField());
            Collections.sort(appDetails, new ChartSorter(payload.getSort()).buildLineChartInfoComparator());
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return appDetails;
    }

    public List<String> buildCodeDistributions(DisplayCommands displayCommands) {
        LinkedList<String> ids = new LinkedList<String>();
        Set orgIds = displayCommands.findOrCreateCommand(0).getCodes().keySet();
        for (String id : orgIds) {
            if (!id.contains("XX") && !CodeDisplayVisitor.STANDALONES.contains(Integer.valueOf(id))) continue;
            ids.add(id);
        }
        Collections.sort(ids, new CodeDistributionComparator(this));
        return ids;
    }

    private AppDataDetail buildComparisonInfo(CommandQueryEntity entity) {
        AppDataDetail appDetail = null;
        try {
            List appDetails = this.m_appDataService.buildAppDataDetailInfos(entity, AppDataField.CODE);
            if (appDetails.size() >= 1) {
                appDetail = (AppDataDetail)appDetails.iterator().next();
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return appDetail;
    }

    private Map<String, AppDataDetail> buildComparisonInfo(Payload payload) {
        AppDataDetail detail;
        CommandQueryEntity currentEntity = payload.getQueryEntity1();
        CommandQueryEntity comparisonEntity = payload.getQueryEntity2();
        HashMap<String, AppDataDetail> result = new HashMap<String, AppDataDetail>();
        if (currentEntity != null && (detail = this.buildComparisonInfo(currentEntity)) != null) {
            result.put("\u5f53\u524d\u503c", detail);
        }
        if (comparisonEntity != null && (detail = this.buildComparisonInfo(comparisonEntity)) != null) {
            result.put("\u5bf9\u6bd4\u503c", detail);
        }
        return result;
    }

    private Pair<LineChart, List<AppDataDetail>> buildConnLineChart(Model model, Payload payload) {
        CommandQueryEntity entity1 = payload.getQueryEntity1();
        CommandQueryEntity entity2 = payload.getQueryEntity2();
        String type = payload.getType();
        LineChart lineChart = new LineChart();
        List appDetails = new ArrayList();
        try {
            lineChart = this.m_appConnectionGraphCreator.buildLineChart(entity1, entity2, type);
            appDetails = this.m_appConnectionService.buildAppDataDetailInfos(entity1, payload.getGroupByField());
            Collections.sort(appDetails, new ChartSorter(payload.getSort()).buildLineChartInfoComparator());
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new Pair((Object)lineChart, appDetails);
    }

    private Pair<PieChart, List<PieChartDetailInfo>> buildConnPieChart(Payload payload) {
        try {
            Pair pair = this.m_appConnectionGraphCreator.buildPieChart(payload.getQueryEntity1(), payload.getGroupByField());
            List infos = (List)pair.getValue();
            Collections.sort(infos, new ChartSorter().buildPieChartInfoComparator());
            return pair;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return null;
        }
    }

    private DisplayCommands buildDisplayCommands(AppReport report, String sort) throws IOException {
        CodeDisplayVisitor distributionVisitor = new CodeDisplayVisitor(this.m_projectService, this.m_appConfigManager);
        distributionVisitor.visitAppReport(report);
        DisplayCommands displayCommands = distributionVisitor.getCommands();
        AppCommandsSorter sorter = new AppCommandsSorter(displayCommands, sort);
        displayCommands = sorter.getSortedCommands();
        return displayCommands;
    }

    private LineChart buildLineChart(Payload payload) {
        CommandQueryEntity entity1 = payload.getQueryEntity1();
        CommandQueryEntity entity2 = payload.getQueryEntity2();
        String type = payload.getType();
        LineChart lineChart = new LineChart();
        try {
            lineChart = this.m_appGraphCreator.buildLineChart(entity1, entity2, type);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return lineChart;
    }

    private Map<String, List<Speed>> buildPageStepInfo() {
        HashMap<String, List<Speed>> page2Steps = new HashMap<String, List<Speed>>();
        for (Speed speed : this.m_appSpeedConfigManager.getConfig().getSpeeds().values()) {
            ArrayList<Speed> steps;
            String page = speed.getPage();
            if (StringUtils.isEmpty((String)page)) {
                page = "default";
            }
            if ((steps = (ArrayList<Speed>)page2Steps.get(page)) == null) {
                steps = new ArrayList<Speed>();
                page2Steps.put(page, steps);
            }
            steps.add(speed);
        }
        for (Map.Entry entry : page2Steps.entrySet()) {
            List speeds = (List)entry.getValue();
            Collections.sort(speeds, new /* Unavailable Anonymous Inner Class!! */);
        }
        return page2Steps;
    }

    private Pair<PieChart, List<PieChartDetailInfo>> buildPieChart(Payload payload) {
        try {
            Pair pair = this.m_appGraphCreator.buildPieChart(payload.getQueryEntity1(), payload.getGroupByField());
            List infos = (List)pair.getValue();
            Collections.sort(infos, new ChartSorter().buildPieChartInfoComparator());
            return pair;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return null;
        }
    }

    private <T> T fetchTaskResult(List<FutureTask> tasks, int i) {
        T data = null;
        FutureTask task = tasks.get(i);
        try {
            data = (T)task.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            task.cancel(true);
            Cat.logError((Throwable)e);
        }
        return data;
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="app")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="app")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        this.normalize(model, payload);
        switch (5.$SwitchMap$com$dianping$cat$report$page$app$Action[action.ordinal()]) {
            case 1: {
                this.parallelBuildLineChart(model, payload);
                break;
            }
            case 2: {
                Pair pieChartPair = this.buildPieChart(payload);
                if (pieChartPair != null) {
                    model.setPieChart((PieChart)pieChartPair.getKey());
                    model.setPieChartDetailInfos((List)pieChartPair.getValue());
                }
                int commandId = payload.getQueryEntity1().getId();
                model.setCommandId(commandId);
                model.setCodes(this.m_appConfigManager.queryInternalCodes(commandId));
                break;
            }
            case 3: {
                this.parallelBuildLineChart(model, payload);
                HashMap<String, Object> lineChartObjs = new HashMap<String, Object>();
                lineChartObjs.put("lineCharts", model.getLineChart());
                lineChartObjs.put("lineChartDailyInfo", model.getComparisonAppDetails());
                lineChartObjs.put("lineChartDetails", model.getAppDataDetailInfos());
                model.setFetchData(new JsonBuilder().toJson(lineChartObjs));
                break;
            }
            case 4: {
                Pair pieChartJsonPair = this.buildPieChart(payload);
                if (pieChartJsonPair == null) break;
                HashMap<String, Object> pieChartObjs = new HashMap<String, Object>();
                pieChartObjs.put("pieCharts", pieChartJsonPair.getKey());
                pieChartObjs.put("pieChartDetails", pieChartJsonPair.getValue());
                model.setFetchData(new JsonBuilder().toJson(pieChartObjs));
                break;
            }
            case 5: {
                String domain = payload.getDomain();
                String name = payload.getName();
                String title = payload.getTitle();
                if (StringUtils.isEmpty((String)name)) {
                    this.setUpdateResult(model, 0);
                    break;
                }
                if (this.m_appConfigManager.isNameDuplicate(name)) {
                    this.setUpdateResult(model, 3);
                    break;
                }
                try {
                    Command command = new Command();
                    command.setDomain(domain).setTitle(title).setName(name);
                    Pair addCommandResult = this.m_appConfigManager.addCommand(command);
                    if (((Boolean)addCommandResult.getKey()).booleanValue()) {
                        this.setUpdateResult(model, 1);
                        this.m_appRuleConfigManager.addDefultRule(name, (Integer)addCommandResult.getValue());
                        break;
                    }
                    this.setUpdateResult(model, 2);
                }
                catch (Exception e) {
                    this.setUpdateResult(model, 2);
                }
                break;
            }
            case 6: {
                String domain = payload.getDomain();
                String name = payload.getName();
                if (StringUtils.isEmpty((String)name)) {
                    this.setUpdateResult(model, 0);
                    break;
                }
                Pair deleteCommandResult = this.m_appConfigManager.deleteCommand(domain, name);
                if (((Boolean)deleteCommandResult.getKey()).booleanValue()) {
                    this.setUpdateResult(model, 1);
                    this.m_appRuleConfigManager.deleteDefaultRule(name, (List)deleteCommandResult.getValue());
                    break;
                }
                this.setUpdateResult(model, 2);
                break;
            }
            case 7: {
                String type = payload.getType();
                try {
                    if ("xml".equalsIgnoreCase(type)) {
                        model.setFetchData(this.m_appConfigManager.getConfig().toString());
                        break;
                    }
                    if (!StringUtils.isEmpty((String)type) && !"json".equalsIgnoreCase(type)) break;
                    model.setFetchData(new JsonBuilder().toJson((Object)this.m_appConfigManager.getConfig()));
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                break;
            }
            case 8: 
            case 9: {
                try {
                    this.m_crashLogProcessor.process(action, payload, model);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                break;
            }
            case 10: {
                try {
                    Map speeds = this.buildPageStepInfo();
                    model.setSpeeds(speeds);
                    SpeedQueryEntity queryEntity1 = this.normalizeQueryEntity(payload, speeds);
                    AppSpeedDisplayInfo info = this.m_appSpeedService.buildSpeedDisplayInfo(queryEntity1, payload.getSpeedQueryEntity2());
                    model.setAppSpeedDisplayInfo(info);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                break;
            }
            case 11: {
                Pair lineChartPair = this.buildConnLineChart(model, payload);
                model.setLineChart((LineChart)lineChartPair.getKey());
                model.setAppDataDetailInfos((List)lineChartPair.getValue());
                break;
            }
            case 12: {
                Pair pieChartPair = this.buildConnPieChart(payload);
                if (pieChartPair != null) {
                    model.setPieChart((PieChart)pieChartPair.getKey());
                    model.setPieChartDetailInfos((List)pieChartPair.getValue());
                }
                int commandId = payload.getQueryEntity1().getId();
                model.setCommandId(commandId);
                model.setCodes(this.m_appConfigManager.queryInternalCodes(commandId));
                break;
            }
            case 13: {
                AppReport report = this.queryAppReport(payload);
                DisplayCommands displayCommands = this.buildDisplayCommands(report, payload.getSort());
                model.setDisplayCommands(displayCommands);
                model.setAppReport(report);
                model.setCodeDistributions(this.buildCodeDistributions(displayCommands));
            }
        }
        if (!ctx.isProcessStopped()) {
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }

    private void normalize(Model model, Payload payload) {
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        model.setPage((Page)ReportPage.APP);
        model.setConnectionTypes(this.m_appConfigManager.queryConfigItem("\u8fde\u63a5\u7c7b\u578b"));
        model.setCities(this.m_appConfigManager.queryConfigItem("\u57ce\u5e02"));
        model.setNetworks(this.m_appConfigManager.queryConfigItem("\u7f51\u7edc\u7c7b\u578b"));
        model.setOperators(this.m_appConfigManager.queryConfigItem("\u8fd0\u8425\u5546"));
        model.setPlatforms(this.m_appConfigManager.queryConfigItem("\u5e73\u53f0"));
        model.setVersions(this.m_appConfigManager.queryConfigItem("\u7248\u672c"));
        model.setCommands(this.m_appConfigManager.queryCommands());
        model.setCommand2Id(this.m_appConfigManager.getCommands());
        model.setCommand2Codes(this.m_appConfigManager.queryCommand2Codes());
        Command defaultCommand = (Command)this.m_appConfigManager.getRawCommands().get(1);
        model.setDefaultCommand(defaultCommand.getName() + "|" + defaultCommand.getTitle());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
    }

    private SpeedQueryEntity normalizeQueryEntity(Payload payload, Map<String, List<Speed>> speeds) {
        List<Speed> first;
        SpeedQueryEntity query1 = payload.getSpeedQueryEntity1();
        if (StringUtils.isEmpty((String)payload.getQuery1()) && !speeds.isEmpty() && (first = speeds.get(speeds.keySet().toArray()[0])) != null && !first.isEmpty()) {
            query1.setId(first.get(0).getId());
        }
        return query1;
    }

    private void parallelBuildLineChart(Model model, Payload payload) {
        ExecutorService executor = Executors.newFixedThreadPool(3);
        LinkedList tasks = new LinkedList();
        FutureTask lineChartTask = new FutureTask(new /* Unavailable Anonymous Inner Class!! */);
        tasks.add(lineChartTask);
        executor.execute(lineChartTask);
        FutureTask appDetailTask = new FutureTask(new /* Unavailable Anonymous Inner Class!! */);
        tasks.add(appDetailTask);
        executor.execute(appDetailTask);
        FutureTask comparisonTask = new FutureTask(new /* Unavailable Anonymous Inner Class!! */);
        tasks.add(comparisonTask);
        executor.execute(comparisonTask);
        LineChart lineChart = (LineChart)this.fetchTaskResult(tasks, 0);
        List appDataDetails = (List)this.fetchTaskResult(tasks, 1);
        Map comparisonDetails = (Map)this.fetchTaskResult(tasks, 2);
        executor.shutdown();
        model.setLineChart(lineChart);
        model.setAppDataDetailInfos(appDataDetails);
        model.setComparisonAppDetails(comparisonDetails);
    }

    private AppReport queryAppReport(Payload payload) {
        Date startDate = payload.getDayDate();
        Date endDate = TimeHelper.addDays((Date)startDate, (int)1);
        AppReport report = this.m_appReportService.queryDailyReport("cat", startDate, endDate);
        return report;
    }

    private void setUpdateResult(Model model, int i) {
        switch (i) {
            case 0: {
                model.setContent("{\"status\":500, \"info\":\"name is required.\"}");
                break;
            }
            case 1: {
                model.setContent("{\"status\":200}");
                break;
            }
            case 2: {
                model.setContent("{\"status\":500}");
                break;
            }
            case 3: {
                model.setContent("{\"status\":500, \"info\":\"name is duplicated.\"}");
            }
        }
    }

    static /* synthetic */ LineChart access$000(Handler x0, Payload x1) {
        return x0.buildLineChart(x1);
    }

    static /* synthetic */ List access$100(Handler x0, Payload x1) {
        return x0.buildAppDataDetails(x1);
    }

    static /* synthetic */ Map access$200(Handler x0, Payload x1) {
        return x0.buildComparisonInfo(x1);
    }
}

