/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app;

import com.dianping.cat.configuration.app.entity.Code;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.configuration.app.entity.Item;
import com.dianping.cat.configuration.app.speed.entity.Speed;
import com.dianping.cat.configuration.server.filter.entity.CrashLogDomain;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.home.app.entity.AppReport;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.PieChart;
import com.dianping.cat.report.page.app.Action;
import com.dianping.cat.report.page.app.Context;
import com.dianping.cat.report.page.app.ProblemStatistics;
import com.dianping.cat.report.page.app.display.AppDataDetail;
import com.dianping.cat.report.page.app.display.AppSpeedDetail;
import com.dianping.cat.report.page.app.display.AppSpeedDisplayInfo;
import com.dianping.cat.report.page.app.display.DisplayCommands;
import com.dianping.cat.report.page.app.display.PieChartDetailInfo;
import com.dianping.cat.report.page.app.processor.CrashLogProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.tuple.Pair;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.view.annotation.EntityMeta;
import org.unidal.web.mvc.view.annotation.ModelMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ModelMeta(value="app")
public class Model
extends AbstractReportModel<Action, ReportPage, Context> {
    @EntityMeta
    private LineChart m_lineChart;
    @EntityMeta
    private PieChart m_pieChart;
    private List<PieChartDetailInfo> m_pieChartDetailInfos;
    private Map<Integer, Item> m_cities;
    private Map<Integer, Item> m_versions;
    private Map<Integer, Item> m_connectionTypes;
    private Map<Integer, Item> m_operators;
    private Map<Integer, Item> m_networks;
    private Map<Integer, Item> m_platforms;
    private List<Command> m_commands;
    private List<AppDataDetail> m_appDataDetailInfos;
    private Map<String, AppDataDetail> m_comparisonAppDetails;
    private AppSpeedDisplayInfo m_appSpeedDisplayInfo;
    private String m_content;
    private String m_fetchData;
    private int m_commandId;
    private ProblemStatistics m_problemStatistics;
    private CrashLogProcessor.FieldsInfo m_fieldsInfo;
    private ProblemReport m_problemReport;
    private Map<String, List<Speed>> m_speeds;
    private Map<Integer, Code> m_codes;
    private List<String> m_codeDistributions;
    private Map<Integer, List<Code>> m_command2Codes;
    private Map<String, Pair<String, String>> m_domain2Departments;
    private Map<String, Command> m_command2Id;
    private String m_defaultCommand;
    @EntityMeta
    private AppReport m_appReport;
    private DisplayCommands m_displayCommands;
    private Collection<CrashLogDomain> m_crashLogDomains;

    public Model(Context ctx) {
        super((ActionContext)ctx);
    }

    public List<AppDataDetail> getAppDataDetailInfos() {
        return this.m_appDataDetailInfos;
    }

    public AppReport getAppReport() {
        return this.m_appReport;
    }

    public Map<String, Map<Integer, AppSpeedDetail>> getAppSpeedDetails() {
        LinkedHashMap<String, Map<Integer, AppSpeedDetail>> map = new LinkedHashMap<String, Map<Integer, AppSpeedDetail>>();
        Map details = this.m_appSpeedDisplayInfo.getAppSpeedDetails();
        if (details != null && !details.isEmpty()) {
            for (Map.Entry entry : details.entrySet()) {
                LinkedHashMap<Integer, AppSpeedDetail> m = new LinkedHashMap<Integer, AppSpeedDetail>();
                for (AppSpeedDetail detail : (List)entry.getValue()) {
                    m.put(detail.getMinuteOrder(), detail);
                }
                map.put((String)entry.getKey(), (Map<Integer, AppSpeedDetail>)m);
            }
        }
        return map;
    }

    public AppSpeedDisplayInfo getAppSpeedDisplayInfo() {
        return this.m_appSpeedDisplayInfo;
    }

    public Map<String, Map<Integer, AppSpeedDetail>> getAppSpeedSummarys() {
        LinkedHashMap<String, Map<Integer, AppSpeedDetail>> map = new LinkedHashMap<String, Map<Integer, AppSpeedDetail>>();
        Map details = this.m_appSpeedDisplayInfo.getAppSpeedSummarys();
        if (details != null && !details.isEmpty()) {
            for (Map.Entry entry : details.entrySet()) {
                LinkedHashMap<Integer, AppSpeedDetail> m = new LinkedHashMap<Integer, AppSpeedDetail>();
                AppSpeedDetail d = (AppSpeedDetail)entry.getValue();
                m.put(d.getMinuteOrder(), d);
                map.put((String)entry.getKey(), (Map<Integer, AppSpeedDetail>)m);
            }
        }
        return map;
    }

    public Map<Integer, Item> getCities() {
        return this.m_cities;
    }

    public List<String> getCodeDistributions() {
        return this.m_codeDistributions;
    }

    public Map<Integer, Code> getCodes() {
        return this.m_codes;
    }

    public Map<Integer, List<Code>> getCommand2Codes() {
        return this.m_command2Codes;
    }

    public String getCommand2CodesJson() {
        return new JsonBuilder().toJson((Object)this.m_command2Codes);
    }

    public Map<String, Command> getCommand2Id() {
        return this.m_command2Id;
    }

    public String getCommand2IdJson() {
        return new JsonBuilder().toJson((Object)this.m_command2Id);
    }

    public int getCommandId() {
        return this.m_commandId;
    }

    public List<Command> getCommands() {
        return this.m_commands;
    }

    public Map<String, AppDataDetail> getComparisonAppDetails() {
        return this.m_comparisonAppDetails;
    }

    public Map<Integer, Item> getConnectionTypes() {
        return this.m_connectionTypes;
    }

    public String getContent() {
        return this.m_content;
    }

    public Collection<CrashLogDomain> getCrashLogDomains() {
        return this.m_crashLogDomains;
    }

    public Action getDefaultAction() {
        return Action.LINECHART;
    }

    public String getDefaultCommand() {
        return this.m_defaultCommand;
    }

    public DisplayCommands getDisplayCommands() {
        return this.m_displayCommands;
    }

    public String getDomain() {
        return this.getDisplayDomain();
    }

    public Map<String, Pair<String, String>> getDomain2Departments() {
        return this.m_domain2Departments;
    }

    public Collection<String> getDomains() {
        return new ArrayList<String>();
    }

    public String getFetchData() {
        return this.m_fetchData;
    }

    public CrashLogProcessor.FieldsInfo getFieldsInfo() {
        return this.m_fieldsInfo;
    }

    public LineChart getLineChart() {
        return this.m_lineChart;
    }

    public Map<Integer, Item> getNetworks() {
        return this.m_networks;
    }

    public Map<Integer, Item> getOperators() {
        return this.m_operators;
    }

    public String getPage2StepsJson() {
        return new JsonBuilder().toJson((Object)this.m_speeds);
    }

    public Set<String> getPages() {
        return this.m_speeds.keySet();
    }

    public PieChart getPieChart() {
        return this.m_pieChart;
    }

    public List<PieChartDetailInfo> getPieChartDetailInfos() {
        return this.m_pieChartDetailInfos;
    }

    public Map<Integer, Item> getPlatforms() {
        return this.m_platforms;
    }

    public ProblemReport getProblemReport() {
        return this.m_problemReport;
    }

    public ProblemStatistics getProblemStatistics() {
        return this.m_problemStatistics;
    }

    public Map<String, List<Speed>> getSpeeds() {
        return this.m_speeds;
    }

    public Map<Integer, Item> getVersions() {
        return this.m_versions;
    }

    public void setAppDataDetailInfos(List<AppDataDetail> appDataDetailInfos) {
        this.m_appDataDetailInfos = appDataDetailInfos;
    }

    public void setAppReport(AppReport appReport) {
        this.m_appReport = appReport;
    }

    public void setAppSpeedDisplayInfo(AppSpeedDisplayInfo appSpeedDisplayInfo) {
        this.m_appSpeedDisplayInfo = appSpeedDisplayInfo;
    }

    public void setCities(Map<Integer, Item> cities) {
        this.m_cities = cities;
    }

    public void setCodeDistributions(List<String> codeDistributions) {
        this.m_codeDistributions = codeDistributions;
    }

    public void setCodes(Map<Integer, Code> codes) {
        this.m_codes = codes;
    }

    public void setCommand2Codes(Map<Integer, List<Code>> command2Codes) {
        this.m_command2Codes = command2Codes;
    }

    public void setCommand2Id(Map<String, Command> rawCommands) {
        this.m_command2Id = rawCommands;
    }

    public void setCommandId(int commandId) {
        this.m_commandId = commandId;
    }

    public void setCommands(List<Command> commands) {
        this.m_commands = commands;
    }

    public void setComparisonAppDetails(Map<String, AppDataDetail> comparisonAppDetail) {
        this.m_comparisonAppDetails = comparisonAppDetail;
    }

    public void setConnectionTypes(Map<Integer, Item> map) {
        this.m_connectionTypes = map;
    }

    public void setContent(String content) {
        this.m_content = content;
    }

    public void setCrashLogDomains(Collection<CrashLogDomain> crashLogDomains) {
        this.m_crashLogDomains = crashLogDomains;
    }

    public void setDefaultCommand(String defaultCommand) {
        this.m_defaultCommand = defaultCommand;
    }

    public void setDisplayCommands(DisplayCommands displayCommands) {
        this.m_displayCommands = displayCommands;
    }

    public void setDomain2Departments(Map<String, Pair<String, String>> domain2Departments) {
        this.m_domain2Departments = domain2Departments;
    }

    public void setFetchData(String fetchData) {
        this.m_fetchData = fetchData;
    }

    public void setFieldsInfo(CrashLogProcessor.FieldsInfo fieldsInfo) {
        this.m_fieldsInfo = fieldsInfo;
    }

    public void setLineChart(LineChart lineChart) {
        this.m_lineChart = lineChart;
    }

    public void setNetworks(Map<Integer, Item> networks) {
        this.m_networks = networks;
    }

    public void setOperators(Map<Integer, Item> operators) {
        this.m_operators = operators;
    }

    public void setPieChart(PieChart pieChart) {
        this.m_pieChart = pieChart;
    }

    public void setPieChartDetailInfos(List<PieChartDetailInfo> pieChartDetailInfos) {
        this.m_pieChartDetailInfos = pieChartDetailInfos;
    }

    public void setPlatforms(Map<Integer, Item> platforms) {
        this.m_platforms = platforms;
    }

    public void setProblemReport(ProblemReport problemReport) {
        this.m_problemReport = problemReport;
    }

    public void setProblemStatistics(ProblemStatistics problemStatistics) {
        this.m_problemStatistics = problemStatistics;
    }

    public void setSpeeds(Map<String, List<Speed>> speeds) {
        this.m_speeds = speeds;
    }

    public void setVersions(Map<Integer, Item> versions) {
        this.m_versions = versions;
    }
}

