/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app;

import com.dianping.cat.consumer.problem.model.entity.Duration;
import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.transform.BaseVisitor;
import com.dianping.cat.report.page.app.ProblemStatistics;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.plexus.util.StringUtils;
import org.unidal.helper.Splitters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemStatistics
extends BaseVisitor {
    private Map<String, TypeStatistics> m_types = new TreeMap();
    private String m_type = "error";
    private String m_status;
    private List<String> m_appVersions;
    private List<String> m_platformVersions;
    private List<String> m_modules;
    private List<String> m_levels;

    private boolean checkFlag(List<String> myFields, String field) {
        return myFields == null || myFields.isEmpty() || !myFields.isEmpty() && myFields.contains(field);
    }

    private boolean checkFlag(String myField, String field) {
        return StringUtils.isEmpty((String)myField) || StringUtils.isNotEmpty((String)myField) && myField.equals(field);
    }

    public List<String> getAppVersions() {
        return this.m_appVersions;
    }

    public List<String> getLevels() {
        return this.m_levels;
    }

    public List<String> getModules() {
        return this.m_modules;
    }

    public List<String> getPlatformVersions() {
        return this.m_platformVersions;
    }

    public String getType() {
        return this.m_type;
    }

    public Map<String, TypeStatistics> getTypes() {
        return this.m_types;
    }

    public void setAppVersions(List<String> appVersions) {
        this.m_appVersions = appVersions;
    }

    public void setLevels(List<String> levels) {
        this.m_levels = levels;
    }

    public void setModules(List<String> modules) {
        this.m_modules = modules;
    }

    public void setPlatformVersions(List<String> platformVersions) {
        this.m_platformVersions = platformVersions;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setTypes(Map<String, TypeStatistics> types) {
        this.m_types = types;
    }

    private void statisticsDuration(Entity entity) {
        boolean flag;
        String type = entity.getType();
        String status = entity.getStatus();
        boolean bl = flag = this.checkFlag(this.m_type, type) && this.checkFlag(this.m_status, status);
        if (flag) {
            Map durations = entity.getDurations();
            for (Map.Entry e : durations.entrySet()) {
                TypeStatistics statusValue = (TypeStatistics)this.m_types.get(type);
                if (statusValue == null) {
                    statusValue = new TypeStatistics(type);
                    this.m_types.put(type, statusValue);
                }
                statusValue.statics(status, (Duration)e.getValue());
            }
        }
    }

    public void visitMachine(Machine machine) {
        boolean flag;
        List names = Splitters.by((String)":").split(machine.getIp());
        String appVersion = (String)names.get(0);
        String platformVersion = (String)names.get(1);
        String module = (String)names.get(2);
        String level = (String)names.get(3);
        boolean bl = flag = this.checkFlag(this.m_appVersions, appVersion) && this.checkFlag(this.m_platformVersions, platformVersion) && this.checkFlag(this.m_modules, module) && this.checkFlag(this.m_levels, level);
        if (flag) {
            for (Entity problem : machine.getEntities().values()) {
                this.statisticsDuration(problem);
            }
        }
    }
}

