/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app.display;

import com.dianping.cat.app.AppConnectionData;
import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.configuration.app.entity.Code;
import com.dianping.cat.configuration.app.entity.Item;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.PieChart;
import com.dianping.cat.report.page.app.display.AppConnectionGraphCreator;
import com.dianping.cat.report.page.app.display.PieChartDetailInfo;
import com.dianping.cat.report.page.app.service.AppConnectionService;
import com.dianping.cat.report.page.app.service.AppDataField;
import com.dianping.cat.report.page.app.service.CommandQueryEntity;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppConnectionGraphCreator {
    @Inject
    private AppConnectionService m_AppConnectionService;
    @Inject
    private AppConfigManager m_appConfigManager;

    public LineChart buildChartData(List<Double[]> datas, String type) {
        LineChart lineChart = new LineChart();
        lineChart.setId("app");
        lineChart.setUnit("");
        lineChart.setHtmlTitle(this.queryType(type));
        if ("success".equals(type)) {
            lineChart.setMinYlable(Double.valueOf(lineChart.queryMinYlable(datas)));
            lineChart.setMaxYlabel(Double.valueOf(100.0));
        }
        for (int i = 0; i < datas.size(); ++i) {
            Double[] data = datas.get(i);
            if (i == 0) {
                lineChart.add("\u5f53\u524d\u503c", data);
                continue;
            }
            if (i != 1) continue;
            lineChart.add("\u5bf9\u6bd4\u503c", data);
        }
        return lineChart;
    }

    public LineChart buildLineChart(CommandQueryEntity queryEntity1, CommandQueryEntity queryEntity2, String type) {
        LinkedList<Double[]> datas = new LinkedList<Double[]>();
        if (queryEntity1 != null) {
            Double[] data1 = this.m_AppConnectionService.queryValue(queryEntity1, type);
            datas.add(data1);
        }
        if (queryEntity2 != null) {
            Double[] values2 = this.m_AppConnectionService.queryValue(queryEntity2, type);
            datas.add(values2);
        }
        return this.buildChartData(datas, type);
    }

    public Pair<PieChart, List<PieChartDetailInfo>> buildPieChart(CommandQueryEntity entity, AppDataField field) {
        LinkedList<PieChartDetailInfo> infos = new LinkedList<PieChartDetailInfo>();
        PieChart pieChart = new PieChart().setMaxSize(Integer.MAX_VALUE);
        ArrayList<PieChart.Item> items = new ArrayList<PieChart.Item>();
        List datas = this.m_AppConnectionService.queryByField(entity, field);
        for (AppConnectionData data : datas) {
            Pair pair = this.buildPieChartItem(entity.getId(), data, field);
            PieChart.Item item = (PieChart.Item)pair.getValue();
            PieChartDetailInfo info = new PieChartDetailInfo();
            info.setId(((Integer)pair.getKey()).intValue()).setTitle(item.getTitle()).setRequestSum(item.getNumber());
            infos.add(info);
            items.add(item);
        }
        pieChart.setTitle(field.getName() + "\u8bbf\u95ee\u60c5\u51b5");
        pieChart.addItems(items);
        this.updatePieChartDetailInfo(infos);
        return new Pair((Object)pieChart, infos);
    }

    private Pair<Integer, String> buildPieChartFieldTitlePair(int command, AppConnectionData data, AppDataField field) {
        String title = "Unknown";
        int keyValue = -1;
        switch (1.$SwitchMap$com$dianping$cat$report$page$app$service$AppDataField[field.ordinal()]) {
            case 1: {
                Map operators = this.m_appConfigManager.queryConfigItem("\u8fd0\u8425\u5546");
                Item operator = null;
                keyValue = data.getOperator();
                if (operators == null || (operator = (Item)operators.get(keyValue)) == null) break;
                title = operator.getName();
                break;
            }
            case 2: {
                Map appVersions = this.m_appConfigManager.queryConfigItem("\u7248\u672c");
                Item appVersion = null;
                keyValue = data.getAppVersion();
                if (appVersions == null || (appVersion = (Item)appVersions.get(keyValue)) == null) break;
                title = appVersion.getName();
                break;
            }
            case 3: {
                Map cities = this.m_appConfigManager.queryConfigItem("\u57ce\u5e02");
                Item city = null;
                keyValue = data.getCity();
                if (cities == null || (city = (Item)cities.get(keyValue)) == null) break;
                title = city.getName();
                break;
            }
            case 4: {
                Map connectTypes = this.m_appConfigManager.queryConfigItem("\u8fde\u63a5\u7c7b\u578b");
                Item connectType = null;
                keyValue = data.getConnectType();
                if (connectTypes == null || (connectType = (Item)connectTypes.get(keyValue)) == null) break;
                title = connectType.getName();
                break;
            }
            case 5: {
                Map networks = this.m_appConfigManager.queryConfigItem("\u7f51\u7edc\u7c7b\u578b");
                Item network = null;
                keyValue = data.getNetwork();
                if (networks == null || (network = (Item)networks.get(keyValue)) == null) break;
                title = network.getName();
                break;
            }
            case 6: {
                Map platforms = this.m_appConfigManager.queryConfigItem("\u5e73\u53f0");
                Item platform = null;
                keyValue = data.getPlatform();
                if (platforms == null || (platform = (Item)platforms.get(keyValue)) == null) break;
                title = platform.getName();
                break;
            }
            case 7: {
                Map codes = this.m_appConfigManager.queryCodeByCommand(command);
                Code code = null;
                keyValue = data.getCode();
                if (codes == null || (code = (Code)codes.get(keyValue)) == null) break;
                title = code.getName();
                int status = code.getStatus();
                if (status == 0) {
                    title = "<span class='text-success'>\u3010\u6210\u529f\u3011</span>" + title;
                    break;
                }
                title = "<span class='text-error'>\u3010\u5931\u8d25\u3011</span>" + title;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized groupby field: " + field);
            }
        }
        if ("Unknown".equals(title)) {
            title = title + " [ " + keyValue + " ]";
        }
        return new Pair((Object)keyValue, (Object)title);
    }

    private Pair<Integer, PieChart.Item> buildPieChartItem(int command, AppConnectionData data, AppDataField field) {
        PieChart.Item item = new PieChart.Item();
        Pair pair = this.buildPieChartFieldTitlePair(command, data, field);
        item.setTitle((String)pair.getValue());
        item.setId(((Integer)pair.getKey()).intValue());
        item.setNumber((double)data.getAccessNumberSum());
        return new Pair(pair.getKey(), (Object)item);
    }

    private String queryType(String type) {
        if ("success".equals(type)) {
            return "\u6210\u529f\u7387\uff08%/5\u5206\u949f\uff09";
        }
        if ("request".equals(type)) {
            return "\u8bf7\u6c42\u6570\uff08\u4e2a/5\u5206\u949f\uff09";
        }
        if ("delay".equals(type)) {
            return "\u5ef6\u65f6\u5e73\u5747\u503c\uff08\u6beb\u79d2/5\u5206\u949f\uff09";
        }
        throw new RuntimeException("unexpected query type, type:" + type);
    }

    private void updatePieChartDetailInfo(List<PieChartDetailInfo> items) {
        double sum = 0.0;
        for (PieChartDetailInfo item : items) {
            sum += item.getRequestSum();
        }
        if (sum > 0.0) {
            for (PieChartDetailInfo item : items) {
                item.setSuccessRatio(item.getRequestSum() / sum);
            }
        }
    }
}

