/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app.display;

import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.core.dal.Project;
import com.dianping.cat.home.app.entity.Code;
import com.dianping.cat.home.app.entity.Transaction;
import com.dianping.cat.home.app.transform.BaseVisitor;
import com.dianping.cat.report.page.app.display.DisplayCode;
import com.dianping.cat.report.page.app.display.DisplayCommand;
import com.dianping.cat.report.page.app.display.DisplayCommands;
import com.dianping.cat.service.ProjectService;
import java.util.Arrays;
import java.util.List;
import org.unidal.lookup.util.StringUtils;

public class CodeDisplayVisitor
extends BaseVisitor {
    private DisplayCommands m_commands = new DisplayCommands();
    private int m_currentCommand;
    private int[] m_distributions = new int[20];
    public static final List<Integer> STANDALONES = Arrays.asList(450);
    private ProjectService m_projectService;
    private AppConfigManager m_appConfigManager;

    public CodeDisplayVisitor(ProjectService projectService, AppConfigManager appConfigManager) {
        this.m_projectService = projectService;
        this.m_appConfigManager = appConfigManager;
        this.init();
    }

    private void buildDistributionInfo(Code code, String id) {
        String title;
        DisplayCode c = this.m_commands.findOrCreateCommand(this.m_currentCommand).findOrCreateCode(id);
        c.incCount(code.getCount()).incErrors(code.getErrors()).incSum(code.getSum());
        long count = c.getCount();
        if (count > 0L) {
            c.setAvg(c.getSum() / (double)count);
            c.setSuccessRatio(100.0 - (double)c.getErrors() * 100.0 / (double)count);
        }
        if (StringUtils.isEmpty((String)(title = c.getTitle()))) {
            title = "";
        }
        StringBuilder sb = new StringBuilder(title);
        sb.append(code.getId() + "=" + code.getCount() + "; ");
        c.setTitle(sb.toString());
    }

    private String convertLable(int i) {
        String code = String.valueOf(i);
        return code.replaceAll("0", "X");
    }

    public DisplayCommands getCommands() {
        return this.m_commands;
    }

    private void init() {
        int i;
        for (i = 1000; i >= 100; i -= 100) {
            this.m_distributions[10 - i / 100] = i;
        }
        for (i = 10; i < 20; ++i) {
            this.m_distributions[i] = -this.m_distributions[i - 10];
        }
    }

    private void mergeCode(Code code, String id) {
        DisplayCode c = this.m_commands.findOrCreateCommand(this.m_currentCommand).findOrCreateCode(id);
        c.incCount(code.getCount()).incErrors(code.getErrors()).incSum(code.getSum());
        long count = c.getCount();
        if (count > 0L) {
            c.setAvg(c.getSum() / (double)count);
            c.setSuccessRatio(100.0 - (double)c.getErrors() * 100.0 / (double)count);
        }
    }

    private void mergeCommand(com.dianping.cat.home.app.entity.Command command) {
        Transaction transaction;
        int id = command.getId();
        DisplayCommand c = this.m_commands.findOrCreateCommand(id);
        if (0 == id) {
            c.setName("All");
            c.setDomain("All");
            c.setTitle("All");
            c.setDepartment("All");
            c.setBu("All");
        } else {
            c.setName(command.getName());
            Command cmd = (Command)this.m_appConfigManager.getRawCommands().get(id);
            if (cmd != null) {
                c.setTitle(cmd.getTitle());
                String domain = cmd.getDomain();
                if (StringUtils.isNotEmpty((String)domain)) {
                    Project project = this.m_projectService.findProject(domain);
                    c.setDomain(domain);
                    if (project != null) {
                        c.setBu(project.getBu());
                        c.setDepartment(project.getCmdbProductline());
                    }
                }
            }
        }
        c.incCount(command.getCount()).incSum(command.getSum()).incErrors(command.getErrors()).incRequestSum(command.getRequestSum()).incResponseSum(command.getResponseSum());
        long count = c.getCount();
        if (count > 0L) {
            c.setAvg(command.getSum() / (double)count);
            c.setSuccessRatio(100.0 - (double)c.getErrors() * 100.0 / (double)count);
            c.setRequestAvg((double)c.getRequestSum() * 1.0 / (double)count);
            c.setResponseAvg((double)c.getResponseSum() * 1.0 / (double)count);
        }
        if ((transaction = command.getTransaction()) != null) {
            c.setTransactionCount(transaction.getCount());
            c.setTransactionAvg(transaction.getAvg());
            if (count > 0L) {
                c.setCountComparison((double)(c.getTransactionCount() - count) * 1.0 / (double)count * 100.0);
            } else {
                c.setCountComparison(100.0);
            }
            double avg = c.getAvg();
            if (avg > 0.0) {
                c.setAvgComparison((c.getTransactionAvg() - avg) / avg * 100.0);
            } else {
                c.setAvgComparison(100.0);
            }
        }
    }

    private String queryCodeDistribution(int code) {
        if (!STANDALONES.contains(code)) {
            if (code >= 0 && code < 100) {
                return "0XX";
            }
            if (code > -100 && code < 0) {
                return "-0XX";
            }
            for (int i = 0; i < this.m_distributions.length; ++i) {
                if (code / this.m_distributions[i] < 1) continue;
                return this.convertLable(this.m_distributions[i]);
            }
        }
        return String.valueOf(code);
    }

    public void visitCode(Code code) {
        String distCode;
        String id = code.getId();
        if (!id.equals(distCode = this.queryCodeDistribution(Integer.valueOf(id).intValue()))) {
            this.buildDistributionInfo(code, distCode);
        }
        this.mergeCode(code, id);
        super.visitCode(code);
    }

    public void visitCommand(com.dianping.cat.home.app.entity.Command command) {
        this.m_currentCommand = command.getId();
        this.mergeCommand(command);
        super.visitCommand(command);
    }
}

