/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app.display;

import com.dianping.cat.report.page.app.display.DisplayCode;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayCommand {
    private int m_id;
    private String m_name;
    private long m_count;
    private double m_sum;
    private double m_avg;
    private long m_errors;
    private double m_successRatio;
    private long m_requestSum;
    private double m_requestAvg;
    private long m_responseSum;
    private double m_responseAvg;
    private long m_transactionCount;
    private double m_transactionAvg;
    private double m_countComparison;
    private double m_avgComparison;
    private String m_domain;
    private String m_bu;
    private String m_department;
    private String m_title;
    private Map<String, DisplayCode> m_codes = new LinkedHashMap();

    public DisplayCommand(int id) {
        this.m_id = id;
    }

    public DisplayCommand addCode(DisplayCode code) {
        this.m_codes.put(code.getId(), code);
        return this;
    }

    public DisplayCode findCode(String id) {
        return (DisplayCode)this.m_codes.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayCode findOrCreateCode(String id) {
        DisplayCode code = (DisplayCode)this.m_codes.get(id);
        if (code == null) {
            Map map = this.m_codes;
            synchronized (map) {
                code = (DisplayCode)this.m_codes.get(id);
                if (code == null) {
                    code = new DisplayCode(id);
                    this.m_codes.put(id, code);
                }
            }
        }
        return code;
    }

    public double getAvg() {
        return this.m_avg;
    }

    public double getAvgComparison() {
        return this.m_avgComparison;
    }

    public String getBu() {
        return this.m_bu;
    }

    public Map<String, DisplayCode> getCodes() {
        return this.m_codes;
    }

    public long getCount() {
        return this.m_count;
    }

    public double getCountComparison() {
        return this.m_countComparison;
    }

    public String getDepartment() {
        return this.m_department;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public long getErrors() {
        return this.m_errors;
    }

    public int getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public double getRequestAvg() {
        return this.m_requestAvg;
    }

    public long getRequestSum() {
        return this.m_requestSum;
    }

    public double getResponseAvg() {
        return this.m_responseAvg;
    }

    public long getResponseSum() {
        return this.m_responseSum;
    }

    public double getSuccessRatio() {
        return this.m_successRatio;
    }

    public double getSum() {
        return this.m_sum;
    }

    public String getTitle() {
        return this.m_title;
    }

    public double getTransactionAvg() {
        return this.m_transactionAvg;
    }

    public long getTransactionCount() {
        return this.m_transactionCount;
    }

    public DisplayCommand incCount() {
        ++this.m_count;
        return this;
    }

    public DisplayCommand incCount(long count) {
        this.m_count += count;
        return this;
    }

    public DisplayCommand incErrors() {
        ++this.m_errors;
        return this;
    }

    public DisplayCommand incErrors(long errors) {
        this.m_errors += errors;
        return this;
    }

    public DisplayCommand incRequestSum() {
        ++this.m_requestSum;
        return this;
    }

    public DisplayCommand incRequestSum(long requestSum) {
        this.m_requestSum += requestSum;
        return this;
    }

    public DisplayCommand incResponseSum() {
        ++this.m_responseSum;
        return this;
    }

    public DisplayCommand incResponseSum(long responseSum) {
        this.m_responseSum += responseSum;
        return this;
    }

    public DisplayCommand incSum() {
        this.m_sum += 1.0;
        return this;
    }

    public DisplayCommand incSum(double sum) {
        this.m_sum += sum;
        return this;
    }

    public void setAvg(double avg) {
        this.m_avg = avg;
    }

    public void setAvgComparison(double avgComparison) {
        this.m_avgComparison = avgComparison;
    }

    public void setBu(String bu) {
        this.m_bu = bu;
    }

    public void setCodes(Map<String, DisplayCode> codes) {
        this.m_codes = codes;
    }

    public void setCount(long count) {
        this.m_count = count;
    }

    public void setCountComparison(double countComparison) {
        this.m_countComparison = countComparison;
    }

    public void setDepartment(String department) {
        this.m_department = department;
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public void setErrors(long errors) {
        this.m_errors = errors;
    }

    public void setId(int id) {
        this.m_id = id;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setRequestAvg(double requestAvg) {
        this.m_requestAvg = requestAvg;
    }

    public void setRequestSum(long requestSum) {
        this.m_requestSum = requestSum;
    }

    public void setResponseAvg(double responseAvg) {
        this.m_responseAvg = responseAvg;
    }

    public void setResponseSum(long responseSum) {
        this.m_responseSum = responseSum;
    }

    public void setSuccessRatio(double successRatio) {
        this.m_successRatio = successRatio;
    }

    public void setSum(double sum) {
        this.m_sum = sum;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setTransactionAvg(double transactionAvg) {
        this.m_transactionAvg = transactionAvg;
    }

    public void setTransactionCount(long transactionCount) {
        this.m_transactionCount = transactionCount;
    }
}

