/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app.processor;

import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.page.app.Action;
import com.dianping.cat.report.page.app.Model;
import com.dianping.cat.report.page.app.Payload;
import com.dianping.cat.report.page.app.ProblemStatistics;
import com.dianping.cat.report.page.app.processor.CrashLogProcessor;
import com.dianping.cat.report.page.problem.service.ProblemReportService;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrashLogProcessor {
    @Inject
    private ProblemReportService m_reportService;
    @Inject(type=ModelService.class, value={"problem"})
    private ModelService<ProblemReport> m_service;
    @Inject
    private PayloadNormalizer m_normalizer;
    @Inject
    private ServerFilterConfigManager m_serverFilterConfigManager;
    private String APP_VERSIONS = "appVersions";
    private String LEVELS = "levels";
    private String MODULES = "modules";
    private String PLATFORM_VERSIONS = "platformVersions";

    private FieldsInfo buildFeildsInfo(ProblemReport report) {
        FieldsInfo fieldsInfo = new FieldsInfo(this);
        Set fields = report.getIps();
        HashMap fieldsMap = new HashMap();
        for (String field : fields) {
            String[] fs = field.split(":");
            this.findOrCreate(this.APP_VERSIONS, fieldsMap).add(fs[0]);
            this.findOrCreate(this.PLATFORM_VERSIONS, fieldsMap).add(fs[1]);
            this.findOrCreate(this.MODULES, fieldsMap).add(fs[2]);
            this.findOrCreate(this.LEVELS, fieldsMap).add(fs[3]);
        }
        if (!fieldsMap.isEmpty()) {
            this.sortFields(fieldsMap, fieldsInfo);
        }
        return fieldsInfo;
    }

    private ProblemStatistics buildProblemStatistics(String query, ProblemReport report) {
        List querys;
        ProblemStatistics problemStatistics = new ProblemStatistics();
        if (StringUtils.isNotEmpty((String)query) && (querys = Splitters.by((String)";").split(query)).size() == 5) {
            problemStatistics.setAppVersions(Splitters.by((String)":").noEmptyItem().split((String)querys.get(1)));
            problemStatistics.setPlatformVersions(Splitters.by((String)":").noEmptyItem().split((String)querys.get(2)));
            problemStatistics.setModules(Splitters.by((String)":").noEmptyItem().split((String)querys.get(3)));
            problemStatistics.setLevels(Splitters.by((String)":").noEmptyItem().split((String)querys.get(4)));
        }
        problemStatistics.visitProblemReport(report);
        return problemStatistics;
    }

    private Set<String> findOrCreate(String key, Map<String, Set<String>> map) {
        Set<String> value = map.get(key);
        if (value == null) {
            value = new HashSet<String>();
            map.put(key, value);
        }
        return value;
    }

    private ProblemReport getHourlyReport(Payload payload, String domain) {
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("queryType", "view");
        if (!StringUtils.isEmpty((String)payload.getType())) {
            request.setProperty("type", "error");
        }
        if (!StringUtils.isEmpty((String)payload.getStatus())) {
            request.setProperty("name", payload.getStatus());
        }
        if (this.m_service.isEligable(request)) {
            ModelResponse response = this.m_service.invoke(request);
            ProblemReport report = (ProblemReport)response.getModel();
            return report;
        }
        throw new RuntimeException("Internal error: no eligible problem service registered for " + request + "!");
    }

    public void process(Action action, Payload payload, Model model) {
        this.m_normalizer.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        ProblemReport report = null;
        switch (2.$SwitchMap$com$dianping$cat$report$page$app$Action[action.ordinal()]) {
            case 1: {
                report = this.getHourlyReport(payload, this.queryDomain(payload));
                break;
            }
            case 2: {
                report = this.showSummarizeReport(model, payload, this.queryDomain(payload));
                break;
            }
            default: {
                throw new RuntimeException("Error action name " + action.getName());
            }
        }
        ProblemStatistics problemStatistics = this.buildProblemStatistics(payload.getQuery1(), report);
        model.setFieldsInfo(this.buildFeildsInfo(report));
        model.setProblemStatistics(problemStatistics);
        model.setProblemReport(report);
        model.setCrashLogDomains(this.m_serverFilterConfigManager.getCrashLogDomains().values());
    }

    private String queryDomain(Payload payload) {
        Set crashLogDomains = this.m_serverFilterConfigManager.getCrashLogDomains().keySet();
        String domain = "";
        if (StringUtils.isNotEmpty((String)payload.getQuery1())) {
            domain = (String)Splitters.by((String)";").split(payload.getQuery1()).get(0);
        }
        if (StringUtils.isEmpty((String)domain)) {
            return (String)crashLogDomains.iterator().next();
        }
        if (crashLogDomains.contains(domain)) {
            return domain;
        }
        throw new RuntimeException("Unknown crash log domain: " + domain);
    }

    private ProblemReport showSummarizeReport(Model model, Payload payload, String domain) {
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        ProblemReport problemReport = (ProblemReport)this.m_reportService.queryReport(domain, start, end);
        return problemReport;
    }

    private void sortFields(Map<String, Set<String>> fieldsMap, FieldsInfo fieldsInfo) {
        1 comparator = new /* Unavailable Anonymous Inner Class!! */;
        ArrayList v = new ArrayList(fieldsMap.get(this.APP_VERSIONS));
        ArrayList l = new ArrayList(fieldsMap.get(this.LEVELS));
        ArrayList m = new ArrayList(fieldsMap.get(this.MODULES));
        ArrayList p = new ArrayList(fieldsMap.get(this.PLATFORM_VERSIONS));
        Collections.sort(v, comparator);
        Collections.sort(p, comparator);
        Collections.sort(m);
        Collections.sort(l);
        fieldsInfo.setAppVersions(v).setPlatVersions(p).setModules(m).setLevels(l);
    }
}

