/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app.service;

import com.dianping.cat.Cat;
import com.dianping.cat.app.AppCommandData;
import com.dianping.cat.app.AppCommandDataDao;
import com.dianping.cat.app.AppCommandDataEntity;
import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.report.page.app.display.AppDataDetail;
import com.dianping.cat.report.page.app.display.AppDataSequence;
import com.dianping.cat.report.page.app.service.AppDataField;
import com.dianping.cat.report.page.app.service.AppDataService;
import com.dianping.cat.report.page.app.service.CommandQueryEntity;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppDataService {
    @Inject
    private AppCommandDataDao m_dao;
    @Inject
    private AppConfigManager m_appConfigManager;
    public static final String SUCCESS = "success";
    public static final String REQUEST = "request";
    public static final String DELAY = "delay";
    public static final String REQUEST_PACKAGE = "requestPackage";
    public static final String RESPONSE_PACKAGE = "responsePackage";

    public List<AppDataDetail> buildAppDataDetailInfos(CommandQueryEntity entity, AppDataField groupByField) {
        LinkedList<AppDataDetail> infos = new LinkedList<AppDataDetail>();
        List datas = this.queryByFieldCode(entity, groupByField);
        Map field2Datas = this.buildFields2Datas(datas, groupByField);
        for (Map.Entry entry : field2Datas.entrySet()) {
            List datalst = (List)entry.getValue();
            AppDataDetail info = new AppDataDetail();
            double ratio = this.computeSuccessRatio(entity.getId(), datalst);
            info.setSuccessRatio(ratio);
            this.updateAppDataDetailInfo(info, entry, groupByField, entity);
            infos.add(info);
        }
        return infos;
    }

    private AppDataSequence<AppCommandData> buildAppSequence(List<AppCommandData> fromDatas, Date period) {
        LinkedHashMap<Integer, LinkedList<AppCommandData>> dataMap = new LinkedHashMap<Integer, LinkedList<AppCommandData>>();
        int max = -5;
        for (AppCommandData from : fromDatas) {
            LinkedList<AppCommandData> data;
            int minute = from.getMinuteOrder();
            if (max < 0 || max < minute) {
                max = minute;
            }
            if ((data = (LinkedList<AppCommandData>)dataMap.get(minute)) == null) {
                data = new LinkedList<AppCommandData>();
                dataMap.put(minute, data);
            }
            data.add(from);
        }
        int n = max / 5 + 1;
        int length = this.queryAppDataDuration(period, n);
        return new AppDataSequence(length, dataMap);
    }

    private Map<Integer, List<AppCommandData>> buildFields2Datas(List<AppCommandData> datas, AppDataField field) {
        HashMap<Integer, List<AppCommandData>> field2Datas = new HashMap<Integer, List<AppCommandData>>();
        for (AppCommandData data : datas) {
            int fieldValue = this.queryFieldValue(data, field);
            ArrayList<AppCommandData> lst = (ArrayList<AppCommandData>)field2Datas.get(fieldValue);
            if (lst == null) {
                lst = new ArrayList<AppCommandData>();
                field2Datas.put(fieldValue, lst);
            }
            lst.add(data);
        }
        return field2Datas;
    }

    public Double[] computeDelayAvg(AppDataSequence<AppCommandData> convertedData) {
        int n = convertedData.getDuration();
        Double[] value = new Double[n];
        for (Map.Entry entry : convertedData.getRecords().entrySet()) {
            for (AppCommandData data : (List)entry.getValue()) {
                long count = data.getAccessNumberSum();
                long sum = data.getResponseSumTimeSum();
                double avg = sum / count;
                int index = data.getMinuteOrder() / 5;
                if (index >= n) continue;
                value[index] = avg;
            }
        }
        return value;
    }

    public Double[] computeRequestCount(AppDataSequence<AppCommandData> convertedData) {
        int n = convertedData.getDuration();
        Double[] value = new Double[n];
        for (Map.Entry entry : convertedData.getRecords().entrySet()) {
            for (AppCommandData data : (List)entry.getValue()) {
                double count = data.getAccessNumberSum();
                int index = data.getMinuteOrder() / 5;
                if (index >= n) continue;
                value[index] = count;
            }
        }
        return value;
    }

    public Double[] computeSuccessRatio(int commandId, AppDataSequence<AppCommandData> convertedData) {
        int n = convertedData.getDuration();
        Double[] value = new Double[n];
        for (int i = 0; i < n; ++i) {
            value[i] = 100.0;
        }
        try {
            for (Map.Entry entry : convertedData.getRecords().entrySet()) {
                int key = (Integer)entry.getKey();
                int index = key / 5;
                if (index >= n) continue;
                value[index] = this.computeSuccessRatio(commandId, (List)entry.getValue());
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return value;
    }

    private double computeSuccessRatio(int commandId, List<AppCommandData> datas) {
        long success = 0L;
        long sum = 0L;
        for (AppCommandData data : datas) {
            long number = data.getAccessNumberSum();
            if (this.m_appConfigManager.isSuccessCode(commandId, data.getCode())) {
                success += number;
            }
            sum += number;
        }
        return sum == 0L ? 0.0 : (double)success / (double)sum * 100.0;
    }

    private int queryAppDataDuration(Date period, int defaultValue) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (period.equals(cal.getTime())) {
            long start = cal.getTimeInMillis();
            long current = System.currentTimeMillis();
            int length = (int)(current - current % 300000L - start) / 300000 - 1;
            return length < 0 ? 0 : length;
        }
        return defaultValue;
    }

    public List<AppCommandData> queryByField(CommandQueryEntity entity, AppDataField groupByField) {
        List<Object> datas = new ArrayList<AppCommandData>();
        int commandId = entity.getId();
        Date period = entity.getDate();
        int city = entity.getCity();
        int operator = entity.getOperator();
        int network = entity.getNetwork();
        int appVersion = entity.getVersion();
        int connnectType = entity.getConnectType();
        int code = entity.getCode();
        int platform = entity.getPlatfrom();
        int startMinuteOrder = entity.getStartMinuteOrder();
        int endMinuteOrder = entity.getEndMinuteOrder();
        try {
            switch (1.$SwitchMap$com$dianping$cat$report$page$app$service$AppDataField[groupByField.ordinal()]) {
                case 1: {
                    datas = this.m_dao.findDataByOperator(commandId, period, city, operator, network, appVersion, connnectType, code, platform, startMinuteOrder, endMinuteOrder, AppCommandDataEntity.READSET_OPERATOR_DATA);
                    break;
                }
                case 2: {
                    datas = this.m_dao.findDataByNetwork(commandId, period, city, operator, network, appVersion, connnectType, code, platform, startMinuteOrder, endMinuteOrder, AppCommandDataEntity.READSET_NETWORK_DATA);
                    break;
                }
                case 3: {
                    datas = this.m_dao.findDataByAppVersion(commandId, period, city, operator, network, appVersion, connnectType, code, platform, startMinuteOrder, endMinuteOrder, AppCommandDataEntity.READSET_APP_VERSION_DATA);
                    break;
                }
                case 4: {
                    datas = this.m_dao.findDataByConnectType(commandId, period, city, operator, network, appVersion, connnectType, code, platform, startMinuteOrder, endMinuteOrder, AppCommandDataEntity.READSET_CONNECT_TYPE_DATA);
                    break;
                }
                case 5: {
                    datas = this.m_dao.findDataByPlatform(commandId, period, city, operator, network, appVersion, connnectType, code, platform, startMinuteOrder, endMinuteOrder, AppCommandDataEntity.READSET_PLATFORM_DATA);
                    break;
                }
                case 6: {
                    datas = this.m_dao.findDataByCity(commandId, period, city, operator, network, appVersion, connnectType, code, platform, startMinuteOrder, endMinuteOrder, AppCommandDataEntity.READSET_CITY_DATA);
                    break;
                }
                case 7: {
                    datas = this.m_dao.findDataByCode(commandId, period, city, operator, network, appVersion, connnectType, code, platform, startMinuteOrder, endMinuteOrder, AppCommandDataEntity.READSET_CODE_DATA);
                }
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return datas;
    }

    public List<AppCommandData> queryByFieldCode(CommandQueryEntity entity, AppDataField groupByField) {
        List<Object> datas = new ArrayList<AppCommandData>();
        int commandId = entity.getId();
        Date period = entity.getDate();
        int city = entity.getCity();
        int operator = entity.getOperator();
        int network = entity.getNetwork();
        int appVersion = entity.getVersion();
        int connnectType = entity.getConnectType();
        int code = entity.getCode();
        int platform = entity.getPlatfrom();
        int startMinuteOrder = entity.getStartMinuteOrder();
        int endMinuteOrder = entity.getEndMinuteOrder();
        try {
            switch (1.$SwitchMap$com$dianping$cat$report$page$app$service$AppDataField[groupByField.ordinal()]) {
                case 1: {
                    datas = this.m_dao.findDataByOperatorCode(commandId, period, city, operator, network, appVersion, connnectType, code, platform, AppCommandDataEntity.READSET_OPERATOR_CODE_DATA);
                    break;
                }
                case 2: {
                    datas = this.m_dao.findDataByNetworkCode(commandId, period, city, operator, network, appVersion, connnectType, code, platform, AppCommandDataEntity.READSET_NETWORK_CODE_DATA);
                    break;
                }
                case 3: {
                    datas = this.m_dao.findDataByAppVersionCode(commandId, period, city, operator, network, appVersion, connnectType, code, platform, AppCommandDataEntity.READSET_APP_VERSION_CODE__DATA);
                    break;
                }
                case 4: {
                    datas = this.m_dao.findDataByConnectTypeCode(commandId, period, city, operator, network, appVersion, connnectType, code, platform, AppCommandDataEntity.READSET_CONNECT_TYPE_CODE_DATA);
                    break;
                }
                case 5: {
                    datas = this.m_dao.findDataByPlatformCode(commandId, period, city, operator, network, appVersion, connnectType, code, platform, AppCommandDataEntity.READSET_PLATFORM_CODE_DATA);
                    break;
                }
                case 6: {
                    datas = this.m_dao.findDataByCityCode(commandId, period, city, operator, network, appVersion, connnectType, code, platform, AppCommandDataEntity.READSET_CITY_CODE_DATA);
                    break;
                }
                case 7: {
                    datas = this.m_dao.findDataByCode(commandId, period, city, operator, network, appVersion, connnectType, code, platform, startMinuteOrder, endMinuteOrder, AppCommandDataEntity.READSET_CODE_DATA);
                }
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return datas;
    }

    private int queryFieldValue(AppCommandData data, AppDataField field) {
        switch (1.$SwitchMap$com$dianping$cat$report$page$app$service$AppDataField[field.ordinal()]) {
            case 1: {
                return data.getOperator();
            }
            case 3: {
                return data.getAppVersion();
            }
            case 6: {
                return data.getCity();
            }
            case 4: {
                return data.getConnectType();
            }
            case 2: {
                return data.getNetwork();
            }
            case 5: {
                return data.getPlatform();
            }
        }
        return -1;
    }

    public double queryOneDayDelayAvg(CommandQueryEntity entity) {
        Double[] values = this.queryValue(entity, DELAY);
        double delaySum = 0.0;
        int size = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            delaySum += values[i].doubleValue();
            ++size;
        }
        return size > 0 ? delaySum / (double)size : -1.0;
    }

    public Double[] queryValue(CommandQueryEntity entity, String type) {
        int commandId = entity.getId();
        Date period = entity.getDate();
        int city = entity.getCity();
        int operator = entity.getOperator();
        int network = entity.getNetwork();
        int appVersion = entity.getVersion();
        int connnectType = entity.getConnectType();
        int code = entity.getCode();
        int platform = entity.getPlatfrom();
        List datas = new ArrayList();
        try {
            if (SUCCESS.equals(type)) {
                datas = this.m_dao.findDataByMinuteCode(commandId, period, city, operator, network, appVersion, connnectType, code, platform, AppCommandDataEntity.READSET_SUCCESS_DATA);
                AppDataSequence s = this.buildAppSequence(datas, entity.getDate());
                return this.computeSuccessRatio(commandId, s);
            }
            if (REQUEST.equals(type)) {
                datas = this.m_dao.findDataByMinute(commandId, period, city, operator, network, appVersion, connnectType, code, platform, AppCommandDataEntity.READSET_COUNT_DATA);
                AppDataSequence s = this.buildAppSequence(datas, entity.getDate());
                return this.computeRequestCount(s);
            }
            if (DELAY.equals(type)) {
                datas = this.m_dao.findDataByMinute(commandId, period, city, operator, network, appVersion, connnectType, code, platform, AppCommandDataEntity.READSET_AVG_DATA);
                AppDataSequence s = this.buildAppSequence(datas, entity.getDate());
                return this.computeDelayAvg(s);
            }
            throw new RuntimeException("unexpected query type, type:" + type);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return null;
        }
    }

    private void setFieldValue(AppDataDetail info, AppDataField field, int value) {
        switch (1.$SwitchMap$com$dianping$cat$report$page$app$service$AppDataField[field.ordinal()]) {
            case 1: {
                info.setOperator(value);
                break;
            }
            case 3: {
                info.setAppVersion(value);
                break;
            }
            case 6: {
                info.setCity(value);
                break;
            }
            case 4: {
                info.setConnectType(value);
                break;
            }
            case 2: {
                info.setNetwork(value);
                break;
            }
            case 5: {
                info.setPlatform(value);
                break;
            }
        }
    }

    private void updateAppDataDetailInfo(AppDataDetail info, Map.Entry<Integer, List<AppCommandData>> entry, AppDataField field, CommandQueryEntity entity) {
        int key = entry.getKey();
        List<AppCommandData> datas = entry.getValue();
        long accessNumberSum = 0L;
        long responseTimeSum = 0L;
        long responsePackageSum = 0L;
        long requestPackageSum = 0L;
        for (AppCommandData data : datas) {
            accessNumberSum += data.getAccessNumberSum();
            responseTimeSum += data.getResponseSumTimeSum();
            responsePackageSum += data.getResponsePackageSum();
            requestPackageSum += data.getRequestPackageSum();
        }
        double responseTimeAvg = accessNumberSum == 0L ? 0.0 : (double)responseTimeSum / (double)accessNumberSum;
        double responsePackageAvg = accessNumberSum == 0L ? 0.0 : (double)responsePackageSum / (double)accessNumberSum;
        double requestPackageAvg = accessNumberSum == 0L ? 0.0 : (double)requestPackageSum / (double)accessNumberSum;
        info.setAccessNumberSum(accessNumberSum).setResponseTimeAvg(responseTimeAvg).setRequestPackageAvg(requestPackageAvg).setResponsePackageAvg(responsePackageAvg).setOperator(entity.getOperator()).setCity(entity.getCity()).setNetwork(entity.getNetwork()).setAppVersion(entity.getVersion()).setPlatform(entity.getPlatfrom()).setConnectType(entity.getConnectType());
        this.setFieldValue(info, field, key);
    }
}

