/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app.service;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.home.app.entity.AppReport;
import com.dianping.cat.home.app.transform.DefaultNativeParser;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppReportService
extends AbstractReportService<AppReport> {
    public AppReport makeReport(String id, Date start, Date end) {
        AppReport report = new AppReport(id);
        report.setStartTime(start).setEndTime(end);
        return report;
    }

    public AppReport queryDailyReport(String id, Date start, Date end) {
        AppReport reportModel = new AppReport(id);
        try {
            DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod(id, "app", start, DailyReportEntity.READSET_FULL);
            reportModel = this.queryFromDailyBinary(report.getId(), id);
        }
        catch (DalNotFoundException report) {
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
        }
        reportModel.setStartTime(start).setEndTime(end);
        return reportModel;
    }

    private AppReport queryFromDailyBinary(int id, String domain) throws DalException {
        DailyReportContent content = this.m_dailyReportContentDao.findByPK(id, DailyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new AppReport(domain);
    }

    public AppReport queryHourlyReport(String id, Date start, Date end) {
        throw new RuntimeException("Top report don't support hourly report");
    }

    public AppReport queryMonthlyReport(String id, Date start) {
        throw new RuntimeException("Top report don't support monthly report");
    }

    public AppReport queryWeeklyReport(String id, Date start) {
        throw new RuntimeException("Top report don't support weekly report");
    }
}

