/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app.service;

import com.dianping.cat.Cat;
import com.dianping.cat.app.AppSpeedData;
import com.dianping.cat.app.AppSpeedDataDao;
import com.dianping.cat.app.AppSpeedDataEntity;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.page.app.display.AppSpeedDetail;
import com.dianping.cat.report.page.app.display.AppSpeedDisplayInfo;
import com.dianping.cat.report.page.app.service.AppSpeedService;
import com.dianping.cat.report.page.app.service.BaseQueryEntity;
import com.dianping.cat.report.page.app.service.SpeedQueryEntity;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSpeedService {
    @Inject
    private AppSpeedDataDao m_dao;
    private static final String CURRENT = "\u5f53\u524d\u503c";
    private static final String COMPARISION = "\u5bf9\u6bd4\u503c";

    private AppSpeedDetail build5MinuteData(int minute, List<AppSpeedData> datas, Date period) {
        long accessSum = 0L;
        long slowAccessSum = 0L;
        long sum = 0L;
        double responseSum = 0.0;
        double responseAvg = 0.0;
        double ratio = 0.0;
        for (AppSpeedData data : datas) {
            accessSum += data.getAccessNumberSum();
            slowAccessSum += data.getSlowAccessNumberSum();
            responseSum += (double)(data.getResponseSumTimeSum() + data.getSlowResponseSumTimeSum());
        }
        sum = accessSum + slowAccessSum;
        if (sum > 0L) {
            ratio = (double)slowAccessSum * 100.0 / (double)sum;
            responseAvg = responseSum / (double)sum;
        }
        AppSpeedDetail d = new AppSpeedDetail();
        d.setPeriod(period);
        d.setMinuteOrder(minute);
        d.setAccessNumberSum(sum);
        d.setResponseTimeAvg(responseAvg);
        d.setSlowRatio(ratio);
        return d;
    }

    private AppSpeedSequence buildAppSequence(List<AppSpeedData> fromDatas, Date period) {
        LinkedHashMap<Integer, LinkedList<AppSpeedData>> dataMap = new LinkedHashMap<Integer, LinkedList<AppSpeedData>>();
        int max = -5;
        for (AppSpeedData from : fromDatas) {
            LinkedList<AppSpeedData> datas;
            int minute = from.getMinuteOrder();
            if (max < 0 || max < minute) {
                max = minute;
            }
            if ((datas = (LinkedList<AppSpeedData>)dataMap.get(minute)) == null) {
                datas = new LinkedList<AppSpeedData>();
                dataMap.put(minute, datas);
            }
            datas.add(from);
        }
        int n = max / 5 + 1;
        int length = this.queryAppDataDuration(period, n);
        return new AppSpeedSequence(this, length, dataMap, period);
    }

    private AppSpeedDisplayInfo buildAppSpeedDisplayInfo(Map<String, AppSpeedSequence> datas) {
        AppSpeedDisplayInfo info = new AppSpeedDisplayInfo();
        info.setLineChart(this.buildLineChart(datas));
        info.setAppSpeedDetails(this.buildSpeedDetail(datas));
        info.setAppSpeedSummarys(this.buildOneDayData(datas));
        return info;
    }

    public LineChart buildLineChart(Map<String, AppSpeedSequence> datas) {
        LineChart lineChart = new LineChart();
        lineChart.setId("app");
        lineChart.setUnit("");
        lineChart.setHtmlTitle("\u5ef6\u65f6\u5e73\u5747\u503c\uff08\u6beb\u79d2/5\u5206\u949f\uff09");
        for (Map.Entry<String, AppSpeedSequence> entry : datas.entrySet()) {
            Double[] data = this.computeDelayAvg(entry.getValue());
            lineChart.add(entry.getKey(), data);
        }
        return lineChart;
    }

    private Map<String, AppSpeedDetail> buildOneDayData(Map<String, AppSpeedSequence> datas) {
        LinkedHashMap<String, AppSpeedDetail> summarys = new LinkedHashMap<String, AppSpeedDetail>();
        for (Map.Entry<String, AppSpeedSequence> entry : datas.entrySet()) {
            try {
                Map appSpeedData = entry.getValue().getRecords();
                Date period = entry.getValue().getPeriod();
                if (appSpeedData.isEmpty()) continue;
                long accessSum = 0L;
                long slowAccessSum = 0L;
                long sum = 0L;
                double responseSum = 0.0;
                double responseAvg = 0.0;
                double ratio = 0.0;
                for (Map.Entry e : appSpeedData.entrySet()) {
                    for (AppSpeedData data : (List)e.getValue()) {
                        accessSum += data.getAccessNumberSum();
                        slowAccessSum += data.getSlowAccessNumberSum();
                        responseSum += (double)(data.getResponseSumTimeSum() + data.getSlowResponseSumTimeSum());
                    }
                }
                sum = accessSum + slowAccessSum;
                ratio = (double)slowAccessSum * 100.0 / (double)sum;
                responseAvg = responseSum / (double)sum;
                AppSpeedDetail d = new AppSpeedDetail();
                d.setPeriod(period);
                d.setAccessNumberSum(sum);
                d.setResponseTimeAvg(responseAvg);
                d.setSlowRatio(ratio);
                summarys.put(entry.getKey(), d);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return summarys;
    }

    private Map<String, List<AppSpeedDetail>> buildSpeedDetail(Map<String, AppSpeedSequence> datas) {
        LinkedHashMap<String, List<AppSpeedDetail>> details = new LinkedHashMap<String, List<AppSpeedDetail>>();
        for (Map.Entry<String, AppSpeedSequence> entry : datas.entrySet()) {
            Map appSpeedDataMap = entry.getValue().getRecords();
            Date period = entry.getValue().getPeriod();
            ArrayList<AppSpeedDetail> detail = new ArrayList<AppSpeedDetail>();
            for (Map.Entry e : appSpeedDataMap.entrySet()) {
                int minute = (Integer)e.getKey();
                List data = (List)e.getValue();
                if (data.isEmpty()) continue;
                detail.add(this.build5MinuteData(minute, data, period));
            }
            details.put(entry.getKey(), detail);
        }
        return details;
    }

    public AppSpeedDisplayInfo buildSpeedDisplayInfo(SpeedQueryEntity queryEntity1, SpeedQueryEntity queryEntity2) {
        Map datas = this.queryRawData(queryEntity1, queryEntity2);
        AppSpeedDisplayInfo appSpeedDisplayInfo = this.buildAppSpeedDisplayInfo(datas);
        return appSpeedDisplayInfo;
    }

    public Double[] computeDelayAvg(AppSpeedSequence convertedData) {
        int n = convertedData.getDuration();
        Double[] value = new Double[n];
        for (Map.Entry entry : convertedData.getRecords().entrySet()) {
            for (AppSpeedData data : (List)entry.getValue()) {
                long count = data.getAccessNumberSum() + data.getSlowAccessNumberSum();
                long sum = data.getResponseSumTimeSum() + data.getSlowResponseSumTimeSum();
                double avg = sum / count;
                int index = data.getMinuteOrder() / 5;
                if (index >= n) continue;
                value[index] = avg;
            }
        }
        return value;
    }

    public Double[] computeRequestCount(AppSpeedSequence convertedData) {
        int n = convertedData.getDuration();
        Double[] value = new Double[n];
        for (Map.Entry entry : convertedData.getRecords().entrySet()) {
            for (AppSpeedData data : (List)entry.getValue()) {
                double count = data.getAccessNumberSum();
                int index = data.getMinuteOrder() / 5;
                if (index >= n) continue;
                value[index] = count;
            }
        }
        return value;
    }

    private int queryAppDataDuration(Date period, int defaultValue) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (period.equals(cal.getTime())) {
            long start = cal.getTimeInMillis();
            long current = System.currentTimeMillis();
            int length = (int)(current - current % 300000L - start) / 300000 - 1;
            return length < 0 ? 0 : length;
        }
        return defaultValue;
    }

    private AppSpeedSequence queryData(SpeedQueryEntity queryEntity) {
        List datas = this.queryValue((BaseQueryEntity)queryEntity);
        AppSpeedSequence sequence = this.buildAppSequence(datas, queryEntity.getDate());
        return sequence;
    }

    public double queryOneDayDelayAvg(AppSpeedSequence sequence) {
        Double[] values = this.computeDelayAvg(sequence);
        double delaySum = 0.0;
        int size = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            delaySum += values[i].doubleValue();
            ++size;
        }
        return size > 0 ? delaySum / (double)size : -1.0;
    }

    private Map<String, AppSpeedSequence> queryRawData(SpeedQueryEntity queryEntity1, SpeedQueryEntity queryEntity2) {
        AppSpeedSequence data2;
        AppSpeedSequence data1;
        LinkedHashMap<String, AppSpeedSequence> datas = new LinkedHashMap<String, AppSpeedSequence>();
        if (queryEntity1 != null && (data1 = this.queryData(queryEntity1)).getDuration() > 0) {
            datas.put(CURRENT, data1);
        }
        if (queryEntity2 != null && (data2 = this.queryData(queryEntity2)).getDuration() > 0) {
            datas.put(COMPARISION, data2);
        }
        return datas;
    }

    public List<AppSpeedData> queryValue(BaseQueryEntity entity) {
        int speedId = entity.getId();
        Date period = entity.getDate();
        int city = entity.getCity();
        int operator = entity.getOperator();
        int network = entity.getNetwork();
        int appVersion = entity.getVersion();
        int platform = entity.getPlatfrom();
        List<Object> datas = new ArrayList<AppSpeedData>();
        try {
            datas = this.m_dao.findDataByMinute(speedId, period, city, operator, network, appVersion, platform, AppSpeedDataEntity.READSET_AVG_DATA);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return datas;
    }
}

