/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app.service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.unidal.lookup.util.StringUtils;

public class BaseQueryEntity {
    protected Date m_date;
    public static final int DEFAULT_VALUE = -1;
    protected int m_id;
    protected int m_network = -1;
    protected int m_version = -1;
    protected int m_platfrom = -1;
    protected int m_city = -1;
    protected int m_operator = -1;

    public BaseQueryEntity() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.m_date = cal.getTime();
    }

    protected int convert2MinuteOrder(String time) {
        int current = -1;
        if (StringUtils.isNotEmpty((String)time)) {
            try {
                current = Integer.parseInt(time);
            }
            catch (NumberFormatException e) {
                String[] pair = time.split(":");
                int hour = Integer.parseInt(pair[0]);
                int minute = Integer.parseInt(pair[1]);
                current = hour * 60 + minute;
                current -= current % 5;
            }
        }
        return current;
    }

    public int getCity() {
        return this.m_city;
    }

    public Date getDate() {
        return this.m_date;
    }

    public int getId() {
        return this.m_id;
    }

    public int getNetwork() {
        return this.m_network;
    }

    public int getOperator() {
        return this.m_operator;
    }

    public int getPlatfrom() {
        return this.m_platfrom;
    }

    public int getVersion() {
        return this.m_version;
    }

    protected Date parseDate(String dateStr) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isNotEmpty((String)dateStr)) {
            return sdf.parse(dateStr);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    protected int parseValue(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    public void setId(int id) {
        this.m_id = id;
    }
}

