/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app.task;

import com.dianping.cat.Cat;
import com.dianping.cat.app.AppCommandData;
import com.dianping.cat.app.AppCommandDataDao;
import com.dianping.cat.app.AppSpeedData;
import com.dianping.cat.app.AppSpeedDataDao;
import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.config.app.AppSpeedConfigManager;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.page.app.task.AppDatabasePruner;
import com.dianping.cat.report.task.TaskBuilder;
import java.util.Calendar;
import java.util.Date;
import org.unidal.dal.jdbc.DalException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;

public class AppDatabasePruner
implements TaskBuilder {
    public static final String ID = "appDatabasePruner";
    @Inject
    private AppSpeedDataDao m_appSpeedDataDao;
    @Inject
    private AppSpeedConfigManager m_appSpeedConfigManager;
    @Inject
    private AppCommandDataDao m_appCommandDataDao;
    @Inject
    private AppConfigManager m_appConfigManager;
    private static final int DURATION = -2;

    public boolean buildDailyTask(String name, String domain, Date period) {
        Threads.forGroup((String)"cat").start((Runnable)new DeleteTask(this));
        return true;
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("daily report builder don't support hourly task");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new RuntimeException("daily report builder don't support monthly task");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new RuntimeException("daily report builder don't support weekly task");
    }

    public void pruneAppCommandTable(Date period, int id) throws DalException {
        AppCommandData appCommandData = new AppCommandDataDao().createLocal();
        appCommandData.setCommandId(id);
        appCommandData.setPeriod(period);
        this.m_appCommandDataDao.deleteBeforePeriod(appCommandData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pruneAppCommndData(Date period) {
        boolean success = true;
        for (Command command : this.m_appConfigManager.queryCommands()) {
            Transaction t = Cat.newTransaction((String)"DeleteTask", (String)"App");
            try {
                this.pruneAppCommandTable(period, command.getId().intValue());
                t.setStatus("0");
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
                t.setStatus((Throwable)e);
                success = false;
            }
            finally {
                t.complete();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pruneAppSpeedData(Date period) {
        boolean succes = true;
        for (Integer speedId : this.m_appSpeedConfigManager.querySpeedIds()) {
            Transaction t = Cat.newTransaction((String)"DeleteTask", (String)"Speed");
            try {
                this.pruneAppSpeedTable(period, speedId.intValue());
                t.setStatus("0");
            }
            catch (DalException e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
                succes = false;
            }
            finally {
                t.complete();
            }
        }
        return succes;
    }

    public void pruneAppSpeedTable(Date period, int speedId) throws DalException {
        AppSpeedData appSpeedData = new AppSpeedDataDao().createLocal();
        appSpeedData.setSpeedId(speedId);
        appSpeedData.setPeriod(period);
        this.m_appSpeedDataDao.deleteBeforePeriod(appSpeedData);
    }

    public boolean pruneDatabase(int months) {
        Date period = this.queryPeriod(months);
        boolean command = this.pruneAppCommndData(period);
        boolean speed = this.pruneAppSpeedData(period);
        return command && speed;
    }

    public Date queryPeriod(int months) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        cal.add(2, months);
        return cal.getTime();
    }
}

