/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app.task;

import com.dianping.cat.Cat;
import com.dianping.cat.app.AppCommandData;
import com.dianping.cat.app.AppCommandDataDao;
import com.dianping.cat.app.AppCommandDataEntity;
import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.app.entity.AppReport;
import com.dianping.cat.home.app.entity.Code;
import com.dianping.cat.home.app.entity.Transaction;
import com.dianping.cat.home.app.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.app.service.AppReportService;
import com.dianping.cat.report.page.app.task.AppReportBuilder;
import com.dianping.cat.report.page.app.task.CommandAutoCompleter;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

public class AppReportBuilder
implements TaskBuilder {
    @Inject
    private AppCommandDataDao m_dao;
    @Inject
    private AppConfigManager m_appConfigManager;
    @Inject
    private AppReportService m_appReportService;
    @Inject
    private TransactionReportService m_transactionReportService;
    @Inject
    private CommandAutoCompleter m_autoCompleter;
    public static final String ID = "app";

    public boolean buildDailyTask(String name, String domain, Date period) {
        try {
            this.m_autoCompleter.autoCompleteDomain(period);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        try {
            AppReport appReport = this.buildDailyReport(domain, period);
            DailyReport report = new DailyReport();
            report.setCreationDate(new Date());
            report.setDomain(domain);
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(name);
            report.setPeriod(period);
            report.setType(1);
            byte[] binaryContent = DefaultNativeBuilder.build((AppReport)appReport);
            return this.m_appReportService.insertDailyReport(report, binaryContent);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    private AppReport buildDailyReport(String id, Date period) {
        AppReport report = this.m_appReportService.makeReport(id, period, TaskHelper.tomorrowZero((Date)period));
        for (Command command : this.m_appConfigManager.queryCommands()) {
            this.processCommand(period, command, report);
        }
        return report;
    }

    private void processCommand(Date period, Command command, AppReport report) {
        int commandId = command.getId();
        List datas = new ArrayList();
        com.dianping.cat.home.app.entity.Command cmd = report.findOrCreateCommand(command.getId().intValue());
        cmd.setName(command.getName());
        try {
            datas = this.m_dao.findDailyDataByCode(commandId, period, AppCommandDataEntity.READSET_CODE_DATA);
            for (AppCommandData data : datas) {
                this.processRecord(commandId, cmd, data);
            }
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
        }
        String domain = command.getDomain();
        if (StringUtils.isNotEmpty((String)domain) && commandId != 0) {
            this.processTransactionInfo(cmd, domain, period);
        }
    }

    private void processTransactionInfo(com.dianping.cat.home.app.entity.Command command, String domain, Date period) {
        Date end = TimeHelper.addDays((Date)period, (int)1);
        TransactionReport report = this.m_transactionReportService.queryDailyReport(domain, period, end);
        TransactionReportVisitor visitor = new TransactionReportVisitor(command.getName());
        visitor.visitTransactionReport(report);
        Transaction transaction = visitor.getTransaction();
        command.setTransaction(transaction);
    }

    private void processRecord(int commandId, com.dianping.cat.home.app.entity.Command cmd, AppCommandData data) {
        long codeCount;
        long cmdCount;
        int codeId = data.getCode();
        boolean success = this.m_appConfigManager.isSuccessCode(commandId, codeId);
        long count = data.getAccessNumberSum();
        long responseTime = data.getResponseSumTimeSum();
        cmd.incCount(count).incSum((double)responseTime).incRequestSum(data.getRequestPackageSum()).incResponseSum(data.getResponsePackageSum());
        Code code = cmd.findOrCreateCode(String.valueOf(codeId));
        code.incCount(count);
        code.incSum((double)responseTime);
        if (!success) {
            cmd.incErrors(count);
            code.incErrors(count);
        }
        if ((cmdCount = cmd.getCount()) > 0L) {
            cmd.setAvg(cmd.getSum() / (double)cmdCount);
            cmd.setSuccessRatio(100.0 - (double)cmd.getErrors() * 100.0 / (double)cmdCount);
            cmd.setRequestAvg((double)cmd.getRequestSum() * 1.0 / (double)cmdCount);
            cmd.setResponseAvg((double)cmd.getResponseSum() * 1.0 / (double)cmdCount);
        }
        if ((codeCount = code.getCount()) > 0L) {
            code.setAvg(code.getSum() / (double)codeCount);
            code.setSuccessRatio(100.0 - (double)code.getErrors() * 100.0 / (double)codeCount);
        }
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("daily report builder don't support hourly task");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new RuntimeException("daily report builder don't support monthly task");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new RuntimeException("daily report builder don't support weekly task");
    }
}

