/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.app.task;

import com.dianping.cat.Cat;
import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.report.page.app.task.CommandAutoCompleter;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.site.lookup.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;

public class CommandAutoCompleter {
    @Inject
    private AppConfigManager m_configManager;
    @Inject
    private TransactionReportService m_reportService;
    private static String SERVER = "warp-connection-server";

    public void autoCompleteDomain(Date period) {
        Collection commands = this.m_configManager.getRawCommands().values();
        Date end = new Date(period.getTime() + 86400000L);
        Set domains = this.m_reportService.queryAllDomainNames(period, end, "transaction");
        for (String domain : domains) {
            try {
                TransactionReportVisitor visitor = new TransactionReportVisitor();
                TransactionReport report = this.m_reportService.queryDailyReport(domain, period, end);
                visitor.visitTransactionReport(report);
                Map urlToDomains = visitor.getUrlToDomains();
                for (Command command : commands) {
                    String commandDomain = command.getDomain();
                    if (!StringUtils.isEmpty((String)commandDomain) && !SERVER.equals(commandDomain)) continue;
                    String commandUrl = command.getName();
                    for (Map.Entry entry : urlToDomains.entrySet()) {
                        if (!((String)entry.getKey()).endsWith(commandUrl)) continue;
                        command.setDomain((String)entry.getValue());
                    }
                }
                this.m_configManager.storeConfig();
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    static /* synthetic */ String access$000() {
        return SERVER;
    }
}

