/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cache;

import com.dianping.cat.consumer.event.model.entity.EventName;
import com.dianping.cat.consumer.event.model.entity.EventType;
import com.dianping.cat.consumer.transaction.model.entity.TransactionName;
import com.dianping.cat.consumer.transaction.model.entity.TransactionType;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.report.page.cache.CacheReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheReport {
    private static final String ALL = "ALL";
    private String m_domain;
    private Set<String> m_domainNames = new LinkedHashSet();
    private Set<String> m_domains;
    private Date m_endTime;
    private Set<String> m_ips = new LinkedHashSet();
    private Map<String, CacheNameItem> m_nameItems = new HashMap();
    private String m_sortBy;
    private Date m_startTime;
    private Map<String, CacheTypeItem> m_typeItems = new HashMap();
    private Set<String> m_methods = new LinkedHashSet();

    private String firstLetterUpper(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public void addNewNameItem(TransactionName transactionName, EventName eventName) {
        String[] arrays = transactionName.getId().split(":");
        String categroy = arrays[0];
        String method = "";
        if (arrays.length > 1) {
            method = this.firstLetterUpper(arrays[1]);
        }
        CacheNameItem item = (CacheNameItem)this.m_nameItems.get(categroy);
        CacheNameItem all = (CacheNameItem)this.m_nameItems.get(ALL);
        if (all == null) {
            all = new CacheNameItem();
            all.setName(new TransactionName(ALL));
            this.m_nameItems.put(ALL, all);
        }
        all.add(transactionName, eventName, method);
        if (item == null) {
            item = new CacheNameItem();
            item.setName(new TransactionName(categroy));
            this.m_nameItems.put(categroy, item);
        }
        item.add(transactionName, eventName, method);
        this.m_methods.add(method);
    }

    public void addNewTypeItem(TransactionType transactionType, EventType eventType) {
        String key = transactionType.getId();
        CacheTypeItem item = (CacheTypeItem)this.m_typeItems.get(key);
        if (item == null) {
            item = new CacheTypeItem();
            item.setType(transactionType);
            item.setMissed(eventType.getTotalCount());
            item.setHited(1.0 - (double)eventType.getTotalCount() / (double)transactionType.getTotalCount());
            this.m_typeItems.put(key, item);
        }
    }

    public String getDomain() {
        return this.m_domain;
    }

    public Set<String> getDomainNames() {
        return this.m_domainNames;
    }

    public Set<String> getDomains() {
        return this.m_domains;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public Set<String> getIps() {
        return this.m_ips;
    }

    public List<CacheNameItem> getNameItems() {
        ArrayList<CacheNameItem> result = new ArrayList<CacheNameItem>(this.m_nameItems.values());
        Collections.sort(result, new CacheNameItemCompator(this.m_sortBy, null));
        return result;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public List<CacheTypeItem> getTypeItems() {
        ArrayList<CacheTypeItem> result = new ArrayList<CacheTypeItem>(this.m_typeItems.values());
        Collections.sort(result, new CacheTypeItemCompator(this.m_sortBy, null));
        return result;
    }

    public Set<String> getMethods() {
        return this.m_methods;
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public void setDomainNames(Set<String> domainNames) {
        this.m_domainNames = domainNames;
    }

    public void setDomains(Set<String> domains) {
        this.m_domains = domains;
    }

    public void setEndTime(Date endTime) {
        this.m_endTime = endTime;
    }

    public void setIps(Set<String> ips) {
        this.m_ips = ips;
    }

    public void setSortBy(String sortBy) {
        this.m_sortBy = sortBy;
    }

    public void setStartTime(Date startTime) {
        this.m_startTime = startTime;
    }

    public String toString() {
        return new JsonBuilder().toJson((Object)this);
    }
}

