/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cache;

import com.dianping.cat.consumer.event.model.entity.EventName;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.event.model.entity.EventType;
import com.dianping.cat.consumer.event.model.entity.Machine;
import com.dianping.cat.consumer.transaction.model.entity.TransactionName;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionType;
import com.dianping.cat.consumer.transaction.model.transform.BaseVisitor;
import com.dianping.cat.report.page.cache.CacheReport;
import org.apache.commons.lang.StringUtils;

public class TransactionReportVistor
extends BaseVisitor {
    private CacheReport m_cacheReport = new CacheReport();
    private String m_currentIp;
    private String m_currentType;
    private EventReport m_eventReport;
    private String m_queryName;
    private String m_sortBy = "missed";
    private String m_type;

    public CacheReport getCacheReport() {
        return this.m_cacheReport;
    }

    private boolean isFit(String queryName, String methodName) {
        String[] args = queryName.split("\\|");
        if (args != null) {
            for (String str : args) {
                if (str.length() <= 0 || !methodName.toLowerCase().contains(str.trim().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public TransactionReportVistor setCurrentIp(String currentIp) {
        this.m_currentIp = currentIp;
        return this;
    }

    public TransactionReportVistor setEventReport(EventReport eventReport) {
        this.m_eventReport = eventReport;
        return this;
    }

    public TransactionReportVistor setQueryName(String queryName) {
        this.m_queryName = queryName;
        return this;
    }

    public TransactionReportVistor setSortBy(String sortBy) {
        if (sortBy != null) {
            this.m_sortBy = sortBy;
        }
        return this;
    }

    public TransactionReportVistor setType(String type) {
        this.m_type = type;
        return this;
    }

    public void visitMachine(com.dianping.cat.consumer.transaction.model.entity.Machine machine) {
        if (machine.getIp().equalsIgnoreCase(this.m_currentIp)) {
            super.visitMachine(machine);
        }
    }

    public void visitName(TransactionName transactionName) {
        String id = transactionName.getId();
        if (!StringUtils.isEmpty((String)this.m_type) && (StringUtils.isEmpty((String)this.m_queryName) || this.isFit(this.m_queryName, id))) {
            Machine machine = this.m_eventReport.findOrCreateMachine(this.m_currentIp);
            EventType eventType = machine.findOrCreateType(this.m_currentType);
            String[] arrays = id.split(":");
            String categroy = arrays[0];
            String method = "";
            if (arrays.length > 1) {
                method = arrays[1];
            }
            EventName eventName = new EventName();
            if (method.equalsIgnoreCase("get")) {
                eventName = eventType.findOrCreateName(categroy + ":missed");
            }
            this.m_cacheReport.addNewNameItem(transactionName, eventName);
        }
    }

    public void visitTransactionReport(TransactionReport transactionReport) {
        this.m_cacheReport.setSortBy(this.m_sortBy);
        super.visitTransactionReport(transactionReport);
        this.m_cacheReport.setDomain(transactionReport.getDomain());
        this.m_cacheReport.setDomainNames(transactionReport.getDomainNames());
        this.m_cacheReport.setStartTime(transactionReport.getStartTime());
        this.m_cacheReport.setEndTime(transactionReport.getEndTime());
        this.m_cacheReport.setIps(transactionReport.getIps());
    }

    public void visitType(TransactionType transactionType) {
        String id = transactionType.getId();
        if (id.startsWith("Cache.")) {
            if (StringUtils.isEmpty((String)this.m_type)) {
                this.m_currentType = transactionType.getId();
                Machine machine = this.m_eventReport.findOrCreateMachine(this.m_currentIp);
                EventType eventType = machine.findOrCreateType(this.m_currentType);
                this.m_cacheReport.addNewTypeItem(transactionType, eventType);
                super.visitType(transactionType);
            } else if (id.equalsIgnoreCase(this.m_type)) {
                this.m_currentType = transactionType.getId();
                super.visitType(transactionType);
            }
        }
    }
}

