/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cdn;

import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.cdn.Action;
import com.dianping.cat.report.page.cdn.Context;
import com.dianping.cat.report.page.cdn.JspViewer;
import com.dianping.cat.report.page.cdn.Model;
import com.dianping.cat.report.page.cdn.Payload;
import com.dianping.cat.report.page.cdn.graph.CdnGraphCreator;
import com.dianping.cat.report.page.web.CityManager;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private CityManager m_cityManager;
    @Inject
    private CdnGraphCreator m_cdnGraphCreator;

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="cdn")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="cdn")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        long start = payload.getHistoryStartDate().getTime();
        long end = payload.getHistoryEndDate().getTime();
        start -= start % 3600000L;
        end -= end % 3600000L;
        Date startDate = new Date(start);
        Date endDate = new Date(end);
        String province = payload.getProvince();
        String city = payload.getCity();
        String cdn = payload.getCdn();
        model.setLineCharts(this.m_cdnGraphCreator.queryBaseInfo(startDate, endDate, cdn, province, city));
        model.setStart(startDate);
        model.setEnd(endDate);
        model.setAction((org.unidal.web.mvc.Action)Action.VIEW);
        model.setPage((Page)ReportPage.CDN);
        model.setCityInfo(this.m_cityManager.getCityInfo());
        if (!ctx.isProcessStopped()) {
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }
}

