/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cdn.graph;

import com.dianping.cat.consumer.metric.model.entity.MetricItem;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.consumer.metric.model.entity.Segment;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.metric.AbstractGraphCreator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdnGraphCreator
extends AbstractGraphCreator {
    private static final String CDN = "cdn";

    private Map<String, LineChart> buildInfoChartData(Map<String, double[]> datas, Date startDate, Date endDate, Map<String, double[]> dataWithOutFutures) {
        LinkedHashMap<String, LineChart> charts = new LinkedHashMap<String, LineChart>();
        int step = this.m_dataExtractor.getStep();
        for (Map.Entry<String, double[]> entry : dataWithOutFutures.entrySet()) {
            String key = entry.getKey();
            double[] value = entry.getValue();
            LineChart lineChart = new LineChart();
            lineChart.setId(key);
            lineChart.setTitle(key);
            lineChart.setStart(startDate);
            lineChart.setSize(value.length);
            lineChart.setStep((long)step * 60000L);
            Map all = this.convertToMap(datas.get(key), startDate, 1);
            Map current = this.convertToMap(dataWithOutFutures.get(key), startDate, step);
            this.addLastMinuteData(current, all, this.m_lastMinute, endDate);
            lineChart.add(entry.getKey(), current);
            charts.put(key, lineChart);
        }
        return charts;
    }

    private Map<String, double[]> fetchData(MetricReport report) {
        LinkedHashMap<String, double[]> data = new LinkedHashMap<String, double[]>();
        Map items = report.getMetricItems();
        for (Map.Entry item : items.entrySet()) {
            String key = (String)item.getKey();
            if (!data.containsKey(key)) {
                double[] values = new double[60];
                for (int i = 0; i < 60; ++i) {
                    values[i] = 0.0;
                }
                data.put(key, values);
            }
            Map segments = ((MetricItem)item.getValue()).getSegments();
            for (Segment segment : segments.values()) {
                int id = segment.getId();
                double[] dArray = (double[])data.get(key);
                int n = id;
                dArray[n] = dArray[n] + segment.getSum();
            }
        }
        return data;
    }

    public Map<String, double[]> prepareAllData(Date startDate, Date endDate, String cdn, String province, String city) {
        long start;
        long end = endDate.getTime();
        int totalSize = (int)((end - start) / 60000L);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("metricType", CDN);
        properties.put(CDN, cdn);
        properties.put("province", province);
        properties.put("city", city);
        LinkedHashMap<String, double[]> sourceValue = new LinkedHashMap<String, double[]>();
        int index = 0;
        for (start = startDate.getTime(); start < end; start += 3600000L) {
            MetricReport report = this.m_metricReportService.queryCdnReport(CDN, properties, new Date(start));
            Map currentValues = this.fetchData(report);
            this.mergeMap(sourceValue, currentValues, totalSize, index);
            ++index;
        }
        return sourceValue;
    }

    public Map<String, LineChart> queryBaseInfo(Date startDate, Date endDate, String cdn, String province, String city) {
        Map oldCurrentValues = this.prepareAllData(startDate, endDate, cdn, province, city);
        Map allCurrentValues = this.m_dataExtractor.extract(oldCurrentValues);
        Map dataWithOutFutures = this.removeFutureData(endDate, allCurrentValues);
        Map lineCharts = this.buildInfoChartData(oldCurrentValues, startDate, endDate, dataWithOutFutures);
        return lineCharts;
    }
}

