/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cdn.graph;

import com.dianping.cat.consumer.metric.model.entity.MetricItem;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.consumer.metric.model.entity.Segment;
import com.dianping.cat.consumer.metric.model.transform.BaseVisitor;
import com.dianping.cat.service.IpService;

public class CdnReportConvertor
extends BaseVisitor {
    private IpService m_ipService;
    private MetricReport m_report;
    private String m_cdn;
    private String m_province;
    private String m_city;
    private static final String ALL = "ALL";

    public CdnReportConvertor(IpService ipService) {
        this.m_ipService = ipService;
    }

    private String filterAndConvert(String cdn, String sip) {
        boolean isAllCdn = this.m_cdn.equals(ALL);
        if (isAllCdn || this.m_cdn.equals(cdn)) {
            IpService.IpInfo ipInfo = this.m_ipService.findIpInfoByString(sip);
            String province = ipInfo.getProvince();
            String city = ipInfo.getCity();
            if (this.m_province.equals(ALL)) {
                if (isAllCdn) {
                    return cdn;
                }
                return province;
            }
            if (this.m_province.equals(province) && (this.m_city.equals(ALL) || this.m_city.equals(city))) {
                if (isAllCdn) {
                    return cdn;
                }
                return city;
            }
        }
        return null;
    }

    public MetricReport getReport() {
        return this.m_report;
    }

    public void mergeMetricItem(MetricItem from, MetricItem to) {
        for (Segment temp : to.getSegments().values()) {
            Segment target = from.findOrCreateSegment(temp.getId());
            this.mergeSegment(target, temp);
        }
    }

    protected void mergeSegment(Segment old, Segment point) {
        old.setCount(old.getCount() + point.getCount());
        old.setSum(old.getSum() + point.getSum());
        if (old.getCount() > 0) {
            old.setAvg(old.getSum() / (double)old.getCount());
        }
    }

    public CdnReportConvertor setCdn(String cdn) {
        this.m_cdn = cdn;
        return this;
    }

    public CdnReportConvertor setCity(String city) {
        this.m_city = city;
        return this;
    }

    public CdnReportConvertor setProvince(String province) {
        this.m_province = province;
        return this;
    }

    public void visitMetricItem(MetricItem metricItem) {
        try {
            String id = metricItem.getId();
            String[] temp = id.split(":");
            String cdn = temp[2];
            String sip = temp[3].trim();
            String key = this.filterAndConvert(cdn, sip);
            if (key != null) {
                MetricItem item = this.m_report.findOrCreateMetricItem(key);
                this.mergeMetricItem(item, metricItem);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void visitMetricReport(MetricReport metricReport) {
        this.m_report = new MetricReport(metricReport.getProduct());
        super.visitMetricReport(metricReport);
    }

    public void visitSegment(Segment segment) {
        super.visitSegment(segment);
    }
}

