/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cross.display;

import com.dianping.cat.consumer.cross.model.entity.CrossReport;
import com.dianping.cat.consumer.cross.model.entity.Local;
import com.dianping.cat.consumer.cross.model.entity.Remote;
import com.dianping.cat.consumer.cross.model.entity.Type;
import com.dianping.cat.consumer.cross.model.transform.BaseVisitor;
import com.dianping.cat.report.page.cross.display.TypeComparator;
import com.dianping.cat.report.page.cross.display.TypeDetailInfo;
import com.dianping.cat.service.HostinfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostInfo
extends BaseVisitor {
    public static final String ALL_CLIENT_IP = "AllClientIP";
    public static final String ALL_SERVER_IP = "AllServerIP";
    private Map<String, TypeDetailInfo> m_callProjectsInfo = new LinkedHashMap();
    private Map<String, TypeDetailInfo> m_serviceProjectsInfo = new LinkedHashMap();
    private Map<String, TypeDetailInfo> m_callerProjectsInfo = new LinkedHashMap();
    private String m_callSortBy = "Avg";
    private String m_clientIp;
    private String m_projectName;
    private long m_reportDuration;
    private String m_serviceSortBy = "Avg";
    private HostinfoService m_hostinfoService;

    public HostInfo(long reportDuration) {
        this.m_reportDuration = reportDuration;
    }

    private void addCallerProject(String ip, Type type) {
        TypeDetailInfo info;
        TypeDetailInfo all = (TypeDetailInfo)this.m_callerProjectsInfo.get(ALL_CLIENT_IP);
        if (all == null) {
            all = new TypeDetailInfo(this.m_reportDuration);
            all.setIp(ALL_CLIENT_IP);
            this.m_callerProjectsInfo.put(ALL_CLIENT_IP, all);
        }
        if ((info = (TypeDetailInfo)this.m_callerProjectsInfo.get(ip)) == null) {
            info = new TypeDetailInfo(this.m_reportDuration);
            info.setIp(ip);
            this.m_callerProjectsInfo.put(ip, info);
        }
        info.mergeType(type);
        all.mergeType(type);
    }

    private void addCallProject(String ip, Type type) {
        TypeDetailInfo info;
        TypeDetailInfo all = (TypeDetailInfo)this.m_callProjectsInfo.get(ALL_SERVER_IP);
        if (all == null) {
            all = new TypeDetailInfo(this.m_reportDuration);
            all.setIp(ALL_SERVER_IP);
            this.m_callProjectsInfo.put(ALL_SERVER_IP, all);
        }
        if ((info = (TypeDetailInfo)this.m_callProjectsInfo.get(ip)) == null) {
            info = new TypeDetailInfo(this.m_reportDuration);
            info.setIp(ip);
            this.m_callProjectsInfo.put(ip, info);
        }
        info.mergeType(type);
        all.mergeType(type);
    }

    private void addServiceProject(String ip, Type type) {
        TypeDetailInfo info;
        TypeDetailInfo all = (TypeDetailInfo)this.m_serviceProjectsInfo.get(ALL_CLIENT_IP);
        if (all == null) {
            all = new TypeDetailInfo(this.m_reportDuration);
            all.setIp(ALL_CLIENT_IP);
            this.m_serviceProjectsInfo.put(ALL_CLIENT_IP, all);
        }
        if ((info = (TypeDetailInfo)this.m_serviceProjectsInfo.get(ip)) == null) {
            info = new TypeDetailInfo(this.m_reportDuration);
            info.setIp(ip);
            this.m_serviceProjectsInfo.put(ip, info);
        }
        info.mergeType(type);
        all.mergeType(type);
    }

    public Map<String, TypeDetailInfo> getCallerProjectsInfo() {
        return this.m_callerProjectsInfo;
    }

    public Collection<TypeDetailInfo> getCallProjectsInfo() {
        ArrayList<TypeDetailInfo> values = new ArrayList<TypeDetailInfo>(this.m_callProjectsInfo.values());
        Collections.sort(values, new TypeComparator(this.m_callSortBy));
        return values;
    }

    public long getReportDuration() {
        return this.m_reportDuration;
    }

    public List<TypeDetailInfo> getServiceProjectsInfo() {
        ArrayList<TypeDetailInfo> values = new ArrayList<TypeDetailInfo>(this.m_serviceProjectsInfo.values());
        Collections.sort(values, new TypeComparator(this.m_serviceSortBy));
        return values;
    }

    public boolean projectContains(String ip, String app, String projectName, String role) {
        if (role.endsWith("Server") ? "AllServers".equals(projectName) : (role.endsWith("Client") || role.endsWith("Caller")) && "AllClients".equals(projectName)) {
            return true;
        }
        if (StringUtils.isNotEmpty((String)app)) {
            if (app.equalsIgnoreCase(projectName)) {
                return true;
            }
        } else {
            String domain;
            if (ip.indexOf(58) > 0) {
                ip = ip.substring(0, ip.indexOf(58));
            }
            if (projectName.equalsIgnoreCase(domain = this.m_hostinfoService.queryDomainByIp(ip))) {
                return true;
            }
        }
        return false;
    }

    public HostInfo setCallSortBy(String callSoryBy) {
        this.m_callSortBy = callSoryBy;
        return this;
    }

    public HostInfo setClientIp(String clientIp) {
        this.m_clientIp = clientIp;
        return this;
    }

    public void setHostinfoService(HostinfoService hostinfoService) {
        this.m_hostinfoService = hostinfoService;
    }

    public HostInfo setProjectName(String projectName) {
        this.m_projectName = projectName;
        return this;
    }

    public HostInfo setServiceSortBy(String serviceSortBy) {
        this.m_serviceSortBy = serviceSortBy;
        return this;
    }

    public void visitCrossReport(CrossReport crossReport) {
        super.visitCrossReport(crossReport);
    }

    public void visitLocal(Local local) {
        if (this.m_clientIp.equalsIgnoreCase("All") || this.m_clientIp.equalsIgnoreCase(local.getId())) {
            super.visitLocal(local);
        }
    }

    public void visitRemote(Remote remote) {
        int index;
        String id = remote.getId();
        String remoteIp = remote.getIp();
        if (remoteIp == null && (index = (remoteIp = id).indexOf(":Caller")) > -1) {
            remoteIp = remoteIp.substring(0, index);
        }
        String role = remote.getRole();
        String app = remote.getApp();
        boolean flag = this.projectContains(id, app, this.m_projectName, role);
        if (flag) {
            if (role != null && role.endsWith("Client")) {
                this.addServiceProject(remoteIp, remote.getType());
            } else if (role != null && role.endsWith("Server")) {
                this.addCallProject(remoteIp, remote.getType());
            } else if (role != null && role.endsWith("Caller")) {
                this.addCallerProject(remoteIp, remote.getType());
            }
        }
    }
}

