/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cross.display;

import com.dianping.cat.consumer.cross.model.entity.CrossReport;
import com.dianping.cat.consumer.cross.model.entity.Local;
import com.dianping.cat.consumer.cross.model.entity.Remote;
import com.dianping.cat.consumer.cross.model.entity.Type;
import com.dianping.cat.consumer.cross.model.transform.BaseVisitor;
import com.dianping.cat.report.page.cross.display.TypeComparator;
import com.dianping.cat.report.page.cross.display.TypeDetailInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectInfo
extends BaseVisitor {
    public static final String ALL_SERVER = "AllServers";
    public static final String ALL_CLIENT = "AllClients";
    private Map<String, TypeDetailInfo> m_callProjectsInfo = new LinkedHashMap();
    private Map<String, TypeDetailInfo> m_serviceProjectsInfo = new LinkedHashMap();
    private Map<String, TypeDetailInfo> m_callerProjectsInfo = new LinkedHashMap();
    private String m_clientIp;
    private long m_reportDuration;
    private String m_callSortBy = "Avg";
    private String m_serviceSortBy = "Avg";

    public ProjectInfo(long reportDuration) {
        this.m_reportDuration = reportDuration;
    }

    private void addCallerProject(String ip, String app, Type type) {
        TypeDetailInfo info;
        String projectName = app;
        TypeDetailInfo all = (TypeDetailInfo)this.m_callerProjectsInfo.get(ALL_CLIENT);
        if (all == null) {
            all = new TypeDetailInfo(this.m_reportDuration, ALL_CLIENT);
            this.m_callerProjectsInfo.put(ALL_CLIENT, all);
        }
        if ((info = (TypeDetailInfo)this.m_callerProjectsInfo.get(projectName)) == null) {
            info = new TypeDetailInfo(this.m_reportDuration, projectName);
            this.m_callerProjectsInfo.put(projectName, info);
        }
        info.mergeType(type);
        all.mergeType(type);
    }

    public void addCallerProjectInfo(String domain, TypeDetailInfo info) {
        TypeDetailInfo all = (TypeDetailInfo)this.m_callerProjectsInfo.get(ALL_CLIENT);
        if (all == null) {
            all = new TypeDetailInfo(this.m_reportDuration, ALL_CLIENT);
            all.setType(info.getType());
            this.m_callerProjectsInfo.put(ALL_CLIENT, all);
        }
        all.mergeTypeDetailInfo(info);
        this.m_callerProjectsInfo.put(domain, info);
    }

    private void addCallProject(String ip, String app, Type type) {
        TypeDetailInfo info;
        String projectName = app;
        TypeDetailInfo all = (TypeDetailInfo)this.m_callProjectsInfo.get(ALL_SERVER);
        if (all == null) {
            all = new TypeDetailInfo(this.m_reportDuration, ALL_SERVER);
            this.m_callProjectsInfo.put(ALL_SERVER, all);
        }
        if ((info = (TypeDetailInfo)this.m_callProjectsInfo.get(projectName)) == null) {
            info = new TypeDetailInfo(this.m_reportDuration, projectName);
            this.m_callProjectsInfo.put(projectName, info);
        }
        info.mergeType(type);
        all.mergeType(type);
    }

    private void addServiceProject(String ip, String app, Type type) {
        TypeDetailInfo info;
        String projectName = app;
        TypeDetailInfo all = (TypeDetailInfo)this.m_serviceProjectsInfo.get(ALL_CLIENT);
        if (all == null) {
            all = new TypeDetailInfo(this.m_reportDuration, ALL_CLIENT);
            this.m_serviceProjectsInfo.put(ALL_CLIENT, all);
        }
        if ((info = (TypeDetailInfo)this.m_serviceProjectsInfo.get(projectName)) == null) {
            info = new TypeDetailInfo(this.m_reportDuration, projectName);
            this.m_serviceProjectsInfo.put(projectName, info);
        }
        info.mergeType(type);
        all.mergeType(type);
    }

    public Map<String, TypeDetailInfo> getAllCallProjectInfo() {
        return this.m_callProjectsInfo;
    }

    public Map<String, TypeDetailInfo> getCallerProjectsInfo() {
        return this.m_callerProjectsInfo;
    }

    public Collection<TypeDetailInfo> getCallProjectsInfo() {
        ArrayList<TypeDetailInfo> values = new ArrayList<TypeDetailInfo>(this.m_callProjectsInfo.values());
        Collections.sort(values, new TypeComparator(this.m_callSortBy));
        return values;
    }

    public long getReportDuration() {
        return this.m_reportDuration;
    }

    public List<TypeDetailInfo> getServiceProjectsInfo() {
        ArrayList<TypeDetailInfo> values = new ArrayList<TypeDetailInfo>(this.m_serviceProjectsInfo.values());
        Collections.sort(values, new TypeComparator(this.m_serviceSortBy));
        return values;
    }

    public ProjectInfo setCallSortBy(String callSoryBy) {
        this.m_callSortBy = callSoryBy;
        return this;
    }

    public ProjectInfo setClientIp(String clientIp) {
        this.m_clientIp = clientIp;
        return this;
    }

    public ProjectInfo setServiceSortBy(String serviceSortBy) {
        this.m_serviceSortBy = serviceSortBy;
        return this;
    }

    public void visitCrossReport(CrossReport crossReport) {
        super.visitCrossReport(crossReport);
    }

    public void visitLocal(Local local) {
        if (this.m_clientIp.equals("All") || this.m_clientIp.equals(local.getId())) {
            super.visitLocal(local);
        }
    }

    public void visitRemote(Remote remote) {
        String remoteIp = remote.getIp();
        if (remoteIp == null) {
            remoteIp = remote.getId();
        }
        String role = remote.getRole();
        String app = remote.getApp();
        if (role != null && role.endsWith("Client")) {
            this.addServiceProject(remoteIp, app, remote.getType());
        } else if (role != null && role.endsWith("Server")) {
            this.addCallProject(remoteIp, app, remote.getType());
        } else if (role != null && role.endsWith("Caller")) {
            this.addCallerProject(remoteIp, app, remote.getType());
        }
    }
}

