/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cross.display;

import com.dianping.cat.report.page.cross.display.TypeDetailInfo;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeComparator
implements Comparator<TypeDetailInfo> {
    private String m_sorted;

    public TypeComparator(String sort) {
        this.m_sorted = sort;
    }

    @Override
    public int compare(TypeDetailInfo m1, TypeDetailInfo m2) {
        if (m1.getProjectName() != null && m1.getProjectName().startsWith("All")) {
            return -1;
        }
        if (m2.getProjectName() != null && m2.getProjectName().startsWith("All")) {
            return 1;
        }
        if (m1.getIp() != null && m1.getIp().startsWith("All")) {
            return -1;
        }
        if (m2.getIp() != null && m2.getIp().startsWith("All")) {
            return 1;
        }
        if (this.m_sorted.equals("name")) {
            if (m1.getProjectName() != null && m2.getProjectName() != null && !m1.getProjectName().equals(m2.getProjectName())) {
                return m1.getProjectName().compareTo(m2.getProjectName());
            }
            if (m1.getIp() != null && m2.getIp() != null && !m1.getIp().equals(m2.getIp())) {
                return m1.getIp().compareTo(m2.getIp());
            }
        }
        if (this.m_sorted.equals("total")) {
            return (int)(m2.getTotalCount() - m1.getTotalCount());
        }
        if (this.m_sorted.equals("failure")) {
            return (int)(m2.getFailureCount() - m1.getFailureCount());
        }
        if (this.m_sorted.equals("failurePercent")) {
            return (int)(m2.getFailurePercent() * 1000.0 - m1.getFailurePercent() * 1000.0);
        }
        if (this.m_sorted.equals("avg")) {
            return (int)(m2.getAvg() * 1000.0 - m1.getAvg() * 1000.0);
        }
        return 0;
    }
}

