/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cross.service;

import com.dianping.cat.consumer.cross.CrossReportMerger;
import com.dianping.cat.consumer.cross.model.IEntity;
import com.dianping.cat.consumer.cross.model.IVisitor;
import com.dianping.cat.consumer.cross.model.entity.CrossReport;
import com.dianping.cat.consumer.cross.model.transform.DefaultSaxParser;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.page.cross.service.LocalCrossService;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.util.Date;
import java.util.List;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCrossService
extends LocalModelService<CrossReport> {
    public static final String ID = "cross";
    @Inject
    private ReportBucketManager m_bucketManager;

    public LocalCrossService() {
        super(ID);
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        List reports = super.getReport(period, domain);
        CrossReport report = null;
        if (reports != null) {
            report = new CrossReport(domain);
            CrossReportMerger merger = new CrossReportMerger(report);
            for (CrossReport tmp : reports) {
                tmp.accept((IVisitor)merger);
            }
        }
        if ((report == null || report.getIps().isEmpty()) && period.isLast()) {
            long startTime = request.getStartTime();
            report = this.getReportFromLocalDisk(startTime, domain);
        }
        return new CrossReportFilter().buildXml((IEntity)report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CrossReport getReportFromLocalDisk(long timestamp, String domain) throws Exception {
        CrossReport report = new CrossReport(domain);
        CrossReportMerger merger = new CrossReportMerger(report);
        report.setStartTime(new Date(timestamp));
        report.setEndTime(new Date(timestamp + 3600000L - 1L));
        for (int i = 0; i < 2; ++i) {
            ReportBucket bucket = null;
            try {
                bucket = this.m_bucketManager.getReportBucket(timestamp, ID, i);
                String xml = bucket.findById(domain);
                if (xml != null) {
                    CrossReport tmp = DefaultSaxParser.parse((String)xml);
                    tmp.accept((IVisitor)merger);
                    continue;
                }
                report.getDomainNames().addAll(bucket.getIds());
                continue;
            }
            finally {
                if (bucket != null) {
                    this.m_bucketManager.closeBucket(bucket);
                }
            }
        }
        return report;
    }
}

