/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dashboard;

import com.dianping.cat.consumer.event.model.entity.EventName;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.event.model.entity.EventType;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.transaction.model.entity.Machine;
import com.dianping.cat.consumer.transaction.model.entity.TransactionName;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionType;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.dashboard.Action;
import com.dianping.cat.report.page.dashboard.Context;
import com.dianping.cat.report.page.dashboard.JspViewer;
import com.dianping.cat.report.page.dashboard.Model;
import com.dianping.cat.report.page.dashboard.Payload;
import com.dianping.cat.report.page.event.transform.EventMergeHelper;
import com.dianping.cat.report.page.problem.transform.ProblemStatistics;
import com.dianping.cat.report.page.transaction.transform.TransactionMergeHelper;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private TransactionMergeHelper m_transactionMergeManger;
    @Inject
    private EventMergeHelper m_eventMergerMergeManager;
    @Inject(type=ModelService.class, value={"event"})
    private ModelService<EventReport> m_eventService;
    @Inject(type=ModelService.class, value={"transaction"})
    private ModelService<TransactionReport> m_transactionService;
    @Inject(type=ModelService.class, value={"problem"})
    private ModelService<ProblemReport> m_problemService;
    @Inject
    private JsonBuilder m_builder;
    private NumberFormat m_format = new DecimalFormat("#0.00");
    private static final String COUNT = "Count";
    private static final String FAILURE_COUNT = "FailureCount";
    private static final String TIME = "ResponseTime";

    private void buildEventReportResult(EventReport eventReport, String ip, String type, String name, Map<String, String> data) {
        com.dianping.cat.consumer.event.model.entity.Machine eventMachine = (com.dianping.cat.consumer.event.model.entity.Machine)eventReport.getMachines().get(ip);
        if (eventMachine != null) {
            EventName eventName;
            EventType eventType;
            if (StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)type)) {
                Collection types = eventMachine.getTypes().values();
                for (EventType eventType2 : types) {
                    String id = eventType2.getId();
                    data.put(id + COUNT, String.valueOf(eventType2.getTotalCount()));
                    data.put(id + FAILURE_COUNT, String.valueOf(eventType2.getFailCount()));
                }
            } else if (StringUtils.isEmpty((String)name) && !StringUtils.isEmpty((String)type)) {
                EventType eventType3 = eventMachine.findType(type);
                if (eventType3 != null) {
                    data.put(COUNT, String.valueOf(eventType3.getTotalCount()));
                    for (EventName eventName2 : eventType3.getNames().values()) {
                        data.put(eventName2.getId() + COUNT, String.valueOf(eventName2.getTotalCount()));
                        data.put(eventName2.getId() + FAILURE_COUNT, String.valueOf(eventName2.getFailCount()));
                    }
                }
            } else if (!StringUtils.isEmpty((String)name) && !StringUtils.isEmpty((String)type) && (eventType = eventMachine.findType(type)) != null && (eventName = eventType.findName(name)) != null) {
                data.put(COUNT, String.valueOf(eventName.getTotalCount()));
                data.put(FAILURE_COUNT, String.valueOf(eventName.getFailCount()));
            }
        }
    }

    private void buildProblemReportResult(ProblemReport problemReport, String ip, String type, String name, Map<String, String> data) {
        ProblemStatistics.StatusStatistics nameValue;
        Map status;
        ProblemStatistics.TypeStatistics value;
        ProblemStatistics problemStatistics = new ProblemStatistics();
        if (ip.equalsIgnoreCase("All")) {
            problemStatistics.setAllIp(true);
        } else {
            problemStatistics.setIp(ip);
        }
        problemStatistics.visitProblemReport(problemReport);
        if (StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)type)) {
            Map status2 = problemStatistics.getStatus();
            for (Map.Entry temp : status2.entrySet()) {
                String key = (String)temp.getKey();
                ProblemStatistics.TypeStatistics value2 = (ProblemStatistics.TypeStatistics)temp.getValue();
                data.put(key + COUNT, String.valueOf(value2.getCount()));
            }
        } else if (StringUtils.isEmpty((String)name) && !StringUtils.isEmpty((String)type)) {
            Map status3 = problemStatistics.getStatus();
            ProblemStatistics.TypeStatistics value3 = (ProblemStatistics.TypeStatistics)status3.get(type);
            if (value3 != null) {
                data.put(COUNT, String.valueOf(value3.getCount()));
                for (Map.Entry temp : value3.getStatus().entrySet()) {
                    data.put((String)temp.getKey() + COUNT, String.valueOf(((ProblemStatistics.StatusStatistics)temp.getValue()).getCount()));
                }
            }
        } else if (!StringUtils.isEmpty((String)name) && !StringUtils.isEmpty((String)type) && (value = (ProblemStatistics.TypeStatistics)(status = problemStatistics.getStatus()).get(type)) != null && (nameValue = (ProblemStatistics.StatusStatistics)value.getStatus().get(name)) != null) {
            data.put(COUNT, String.valueOf(nameValue.getCount()));
        }
    }

    private void buildTransactionReportResult(TransactionReport transactionReport, String ip, String type, String name, Map<String, String> data) {
        Machine transactionMachine = (Machine)transactionReport.getMachines().get(ip);
        if (transactionMachine != null) {
            TransactionName transactionName;
            TransactionType transactionType;
            if (StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)type)) {
                Collection types = transactionMachine.getTypes().values();
                for (TransactionType transactionType2 : types) {
                    String id = transactionType2.getId();
                    data.put(id + TIME, this.m_format.format(transactionType2.getAvg()));
                    data.put(id + COUNT, String.valueOf(transactionType2.getTotalCount()));
                    data.put(id + FAILURE_COUNT, String.valueOf(transactionType2.getFailCount()));
                }
            } else if (StringUtils.isEmpty((String)name) && !StringUtils.isEmpty((String)type)) {
                TransactionType transactionType3 = transactionMachine.findType(type);
                if (transactionType3 != null) {
                    data.put(TIME, this.m_format.format(transactionType3.getAvg()));
                    data.put(COUNT, String.valueOf(transactionType3.getTotalCount()));
                    data.put(FAILURE_COUNT, String.valueOf(transactionType3.getFailCount()));
                    for (TransactionName transactionName2 : transactionType3.getNames().values()) {
                        String id = transactionName2.getId();
                        data.put(id + TIME, this.m_format.format(transactionName2.getAvg()));
                        data.put(id + COUNT, String.valueOf(transactionName2.getTotalCount()));
                        data.put(id + FAILURE_COUNT, String.valueOf(transactionName2.getFailCount()));
                    }
                }
            } else if (!StringUtils.isEmpty((String)name) && !StringUtils.isEmpty((String)type) && (transactionType = transactionMachine.findType(type)) != null && (transactionName = transactionType.findName(name)) != null) {
                data.put(TIME, this.m_format.format(transactionName.getAvg()));
                data.put(COUNT, String.valueOf(transactionName.getTotalCount()));
                data.put(FAILURE_COUNT, String.valueOf(transactionName.getFailCount()));
            }
        }
    }

    private Map<String, String> getBaseInfoByDomianAndIp(String domain, String ip) {
        EventReport eventReport;
        HashMap<String, String> data = new HashMap<String, String>();
        TransactionReport transactionReport = this.getTransactionHourlyReport(domain, ip, null);
        if (transactionReport == null) {
            return data;
        }
        Machine transactionMachine = (Machine)transactionReport.getMachines().get(ip);
        if (transactionMachine != null) {
            Collection types = transactionMachine.getTypes().values();
            for (TransactionType type : types) {
                String name = type.getId();
                data.put(name + TIME, this.m_format.format(type.getAvg()));
                data.put(name + COUNT, this.m_format.format(type.getTotalCount()));
            }
        }
        if ((eventReport = this.getEventHourlyReport(domain, ip, null)) == null) {
            return data;
        }
        com.dianping.cat.consumer.event.model.entity.Machine eventMachine = (com.dianping.cat.consumer.event.model.entity.Machine)eventReport.getMachines().get(ip);
        if (eventMachine != null) {
            long exceptionCount = 0L;
            EventType exception = eventMachine.findType("Exception");
            EventType runtimeException = eventMachine.findType("RuntimeException");
            if (exception != null) {
                exceptionCount += exception.getTotalCount();
            }
            if (runtimeException != null) {
                exceptionCount += runtimeException.getTotalCount();
            }
            data.put("Exception", String.valueOf(exceptionCount));
        }
        return data;
    }

    private EventReport getEventHourlyReport(String domain, String ip, String type) {
        ModelRequest request = new ModelRequest(domain, ModelPeriod.CURRENT.getStartTime()).setProperty("ip", ip);
        if (!StringUtils.isEmpty((String)type)) {
            request.setProperty("type", type);
        }
        if (this.m_eventService.isEligable(request)) {
            ModelResponse response = this.m_eventService.invoke(request);
            EventReport report = (EventReport)response.getModel();
            report = this.m_eventMergerMergeManager.mergeAllIps(report, ip);
            return report;
        }
        throw new RuntimeException("Internal error: no eligable transaction service registered for " + request + "!");
    }

    private ProblemReport getProblemHourlyReport(String domain, String ip) {
        ModelRequest request = new ModelRequest(domain, ModelPeriod.CURRENT.getStartTime()).setProperty("type", "view");
        if (!ip.equalsIgnoreCase("All")) {
            request.setProperty("ip", ip);
        }
        if (this.m_transactionService.isEligable(request)) {
            ModelResponse response = this.m_problemService.invoke(request);
            ProblemReport report = (ProblemReport)response.getModel();
            return report;
        }
        throw new RuntimeException("Internal error: no eligable transaction service registered for " + request + "!");
    }

    private TransactionReport getTransactionHourlyReport(String domain, String ip, String type) {
        ModelRequest request = new ModelRequest(domain, ModelPeriod.CURRENT.getStartTime()).setProperty("ip", ip);
        if (!StringUtils.isEmpty((String)type)) {
            request.setProperty("type", type);
        }
        if (this.m_transactionService.isEligable(request)) {
            ModelResponse response = this.m_transactionService.invoke(request);
            TransactionReport report = (TransactionReport)response.getModel();
            report = this.m_transactionMergeManger.mergeAllMachines(report, ip);
            return report;
        }
        throw new RuntimeException("Internal error: no eligable transaction service registered for " + request + "!");
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="dashboard")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="dashboard")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        HashMap<String, String> data = new HashMap<String, String>();
        model.setAction((org.unidal.web.mvc.Action)Action.VIEW);
        model.setPage((Page)ReportPage.DASHBOARD);
        data.put("timestamp", String.valueOf(new Date().getTime()));
        String domain = payload.getDomain();
        if (!StringUtils.isEmpty((String)domain)) {
            String report = payload.getReport();
            String type = payload.getType();
            String name = payload.getName();
            String ip = payload.getIp();
            if (!StringUtils.isEmpty((String)report)) {
                if ("transaction".equalsIgnoreCase(report)) {
                    TransactionReport transactionReport = this.getTransactionHourlyReport(domain, ip, type);
                    this.buildTransactionReportResult(transactionReport, ip, type, name, data);
                } else if ("event".equalsIgnoreCase(report)) {
                    EventReport eventReport = this.getEventHourlyReport(domain, ip, type);
                    this.buildEventReportResult(eventReport, ip, type, name, data);
                } else if ("problem".equalsIgnoreCase(report)) {
                    ProblemReport problemReport = this.getProblemHourlyReport(domain, ip);
                    this.buildProblemReportResult(problemReport, ip, type, name, data);
                }
            } else {
                Map temp = this.getBaseInfoByDomianAndIp(domain, ip);
                data.putAll(temp);
            }
        }
        model.setData(this.m_builder.toJson(data));
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }
}

