/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.database;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.metric.model.entity.MetricItem;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.consumer.metric.model.entity.Segment;
import com.dianping.cat.consumer.metric.model.transform.BaseVisitor;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseReportFilter
extends BaseVisitor {
    private MetricReport m_report;
    private List<String> m_keys;

    public DatabaseReportFilter(List<String> keys) {
        this.m_keys = keys;
    }

    public MetricReport getReport() {
        return this.m_report;
    }

    public void mergeMetricItem(MetricItem to, MetricItem from) {
        for (Segment temp : from.getSegments().values()) {
            Segment target = to.findOrCreateSegment(temp.getId());
            this.mergeSegment(target, temp);
        }
    }

    protected void mergeSegment(Segment to, Segment from) {
        to.setCount(from.getCount());
        to.setSum(from.getSum());
        to.setAvg(from.getAvg());
    }

    public void setReport(MetricReport report) {
        this.m_report = report;
    }

    private boolean validate(String id) {
        try {
            if (this.m_keys != null && !this.m_keys.isEmpty()) {
                int index = id.indexOf(":", id.indexOf(":") + 1);
                String realKey = id.substring(index + 1);
                return this.m_keys.contains(realKey);
            }
            return true;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return true;
        }
    }

    public void visitMetricItem(MetricItem metricItem) {
        String id = metricItem.getId();
        if (this.validate(id)) {
            MetricItem item = this.m_report.findOrCreateMetricItem(id);
            item.setType(metricItem.getType());
            this.mergeMetricItem(item, metricItem);
        }
    }

    public void visitMetricReport(MetricReport metricReport) {
        this.m_report = new MetricReport(metricReport.getProduct());
        this.m_report.setStartTime(metricReport.getStartTime());
        this.m_report.setEndTime(metricReport.getEndTime());
        super.visitMetricReport(metricReport);
    }
}

