/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.database;

import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.report.alert.AlertInfo;
import com.dianping.cat.report.alert.MetricType;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.metric.AbstractGraphCreator;
import com.dianping.cat.report.page.database.DatabaseGroup;
import com.dianping.cat.report.page.database.DatabaseReportFilter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphCreator
extends AbstractGraphCreator {
    private Map<String, LineChart> buildChartData(String productLine, Map<String, double[]> datas, Date startDate, Date endDate, Map<String, double[]> dataWithOutFutures) {
        LinkedHashMap<String, LineChart> charts = new LinkedHashMap<String, LineChart>();
        List alertKeys = this.m_alertInfo.queryLastestAlarmKey(5);
        int step = this.m_dataExtractor.getStep();
        for (Map.Entry<String, double[]> entry : dataWithOutFutures.entrySet()) {
            String key = entry.getKey();
            double[] value = entry.getValue();
            LineChart lineChart = new LineChart();
            this.buildLineChartTitle(alertKeys, lineChart, key);
            lineChart.setStart(startDate);
            lineChart.setSize(value.length);
            lineChart.setUnit("Value/\u79d2");
            lineChart.setMinYlable(Double.valueOf(lineChart.queryMinYlable(value)));
            lineChart.setStep((long)step * 60000L);
            Map all = this.convertToMap(datas.get(key), startDate, 1);
            Map current = this.convertToMap(dataWithOutFutures.get(key), startDate, step);
            this.addLastMinuteData(current, all, this.m_lastMinute, endDate);
            lineChart.add("\u5f53\u524d\u503c", current);
            charts.put(key, lineChart);
        }
        return charts;
    }

    public Map<String, LineChart> buildChartsByProductLine(String group, String productLine, Date startDate, Date endDate) {
        Map oldCurrentValues = this.prepareAllData(group, productLine, startDate, endDate);
        Map allCurrentValues = this.m_dataExtractor.extract(oldCurrentValues);
        Map dataWithOutFutures = this.removeFutureData(endDate, allCurrentValues);
        return this.buildChartData(productLine, oldCurrentValues, startDate, endDate, dataWithOutFutures);
    }

    private Map<String, double[]> buildGraphData(MetricReport metricReport) {
        Map datas = this.m_pruductDataFetcher.buildGraphData(metricReport);
        LinkedHashMap<String, double[]> values = new LinkedHashMap<String, double[]>();
        for (Map.Entry entry : datas.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.endsWith(MetricType.SUM.name())) continue;
            this.putKey(datas, values, key);
        }
        return values;
    }

    private void buildLineChartTitle(List<AlertInfo.AlertMetric> alertKeys, LineChart chart, String key) {
        int index = key.lastIndexOf(":");
        String type = key.substring(index + 1);
        String des = this.queryMetricItemDes(type);
        String[] strs = key.split(":");
        String title = strs[2] + des;
        chart.setTitle(title);
        chart.setHtmlTitle(title);
        chart.setId(key);
    }

    private Map<String, double[]> prepareAllData(String group, String productLine, Date startDate, Date endDate) {
        long start;
        long end = endDate.getTime();
        int totalSize = (int)((end - start) / 60000L);
        LinkedHashMap<String, double[]> oldCurrentValues = new LinkedHashMap<String, double[]>();
        int index = 0;
        for (start = startDate.getTime(); start < end; start += 3600000L) {
            Map currentValues = this.queryMetricValueByDate(group, productLine, start);
            this.mergeMap(oldCurrentValues, currentValues, totalSize, index);
            ++index;
        }
        return oldCurrentValues;
    }

    private String queryMetricItemDes(String type) {
        String des = "";
        if (MetricType.AVG.name().equals(type)) {
            des = "(\u5e73\u5747)";
        } else if (MetricType.SUM.name().equals(type)) {
            des = "(\u603b\u548c)";
        } else if (MetricType.COUNT.name().equals(type)) {
            des = "(\u6b21\u6570)";
        }
        return des;
    }

    private Map<String, double[]> queryMetricValueByDate(String group, String productLine, long start) {
        MetricReport metricReport = this.m_metricReportService.queryMetricReport(productLine, new Date(start));
        List keys = (List)DatabaseGroup.KEY_GROUPS.get(group);
        DatabaseReportFilter filter = new DatabaseReportFilter(keys);
        filter.visitMetricReport(metricReport);
        metricReport = filter.getReport();
        Map currentValues = this.buildGraphData(metricReport);
        double sum = 0.0;
        for (Map.Entry entry : currentValues.entrySet()) {
            double[] value = (double[])entry.getValue();
            int length = value.length;
            for (int i = 0; i < length; ++i) {
                sum += value[i];
            }
        }
        return currentValues;
    }
}

