/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.database;

import com.dianping.cat.consumer.company.model.entity.ProductLine;
import com.dianping.cat.consumer.config.ProductLineConfigManager;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.database.Context;
import com.dianping.cat.report.page.database.DatabaseGroup;
import com.dianping.cat.report.page.database.GraphCreator;
import com.dianping.cat.report.page.database.Handler;
import com.dianping.cat.report.page.database.JspViewer;
import com.dianping.cat.report.page.database.Model;
import com.dianping.cat.report.page.database.Payload;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.Action;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private ProductLineConfigManager m_productLineConfigManager;
    @Inject
    private GraphCreator m_graphCreator;

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="database")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="database")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        this.normalize(model, payload);
        long date = payload.getDate();
        int timeRange = payload.getTimeRange();
        Date start = new Date(date - (long)(timeRange - 1) * 3600000L);
        Date end = new Date(date + 3600000L);
        switch (1.$SwitchMap$com$dianping$cat$report$page$database$Action[payload.getAction().ordinal()]) {
            case 1: {
                Map charts = this.m_graphCreator.buildChartsByProductLine(payload.getGroup(), payload.getProduct(), start, end);
                model.setLineCharts(new ArrayList(charts.values()));
                model.setGroups(DatabaseGroup.KEY_GROUPS.keySet());
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private void normalize(Model model, Payload payload) {
        ArrayList databases = new ArrayList(this.m_productLineConfigManager.queryDatabaseProductLines().values());
        model.setPage((Page)ReportPage.DATABASE);
        model.setProductLines(databases);
        model.setAction((Action)payload.getAction());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        if (StringUtils.isEmpty((String)payload.getProduct())) {
            if (databases.size() > 0) {
                payload.setProduct(((ProductLine)databases.get(0)).getId());
            } else {
                payload.setProduct("Default");
            }
        }
        int timeRange = payload.getTimeRange();
        Date startTime = new Date(payload.getDate() - (long)(timeRange - 1) * 3600000L);
        Date endTime = new Date(payload.getDate() + 3600000L - 1L);
        model.setStartTime(startTime);
        model.setEndTime(endTime);
    }
}

