/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency;

import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.home.dependency.graph.entity.TopologyGraph;
import com.dianping.cat.home.dependency.graph.entity.TopologyNode;
import com.dianping.cat.report.page.dependency.Model;
import com.dianping.cat.report.page.dependency.Payload;
import com.dianping.cat.report.page.dependency.ProblemInfoVisitor;
import com.dianping.cat.report.page.dependency.graph.GraphConstrant;
import com.dianping.cat.report.page.dependency.service.DependencyReportService;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.unidal.lookup.annotation.Inject;

public class ExternalInfoBuilder {
    @Inject(type=ModelService.class, value={"problem"})
    private ModelService<ProblemReport> m_problemservice;
    @Inject
    private DependencyReportService m_reportService;
    @Inject
    protected ServerConfigManager m_serverConfigManager;
    private SimpleDateFormat m_dateFormat = new SimpleDateFormat("yyyyMMddHH");

    public void buildExceptionInfoOnGraph(Payload payload, Model model, TopologyGraph graph) {
        if (graph.getStatus() != GraphConstrant.OK) {
            String problemInfo = this.buildProblemInfo(graph.getId(), payload);
            graph.setDes(graph.getDes() + problemInfo);
        }
        for (TopologyNode node : graph.getNodes().values()) {
            node.setLink(this.buildTopologyNodeLink(payload, model, node.getId()));
            if (!node.getType().equals("project") || node.getStatus() == GraphConstrant.OK) continue;
            String problemInfo = this.buildProblemInfo(node.getId(), payload);
            node.setDes(node.getDes() + problemInfo);
        }
    }

    public void buildNodeExceptionInfo(TopologyNode node, Model model, Payload payload) {
        String domain = node.getId();
        if (node.getStatus() != GraphConstrant.OK) {
            String exceptionInfo = this.buildProblemInfo(domain, payload);
            node.setDes(node.getDes() + exceptionInfo);
        }
    }

    private String buildProblemInfo(String domain, Payload payload) {
        ProblemReport report = this.queryProblemReport(payload, domain);
        ProblemInfoVisitor visitor = new ProblemInfoVisitor();
        visitor.visitProblemReport(report);
        return visitor.buildExceptionInfo();
    }

    private String buildTopologyNodeLink(Payload payload, Model model, String domain) {
        return String.format("?op=dependencyGraph&minute=%s&domain=%s&date=%s", model.getMinute(), domain, this.m_dateFormat.format(new Date(payload.getDate())));
    }

    private ProblemReport queryProblemReport(Payload payload, String domain) {
        String date = String.valueOf(payload.getDate());
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("date", date).setProperty("type", "view");
        if (this.m_problemservice.isEligable(request)) {
            ModelResponse response = this.m_problemservice.invoke(request);
            return (ProblemReport)response.getModel();
        }
        throw new RuntimeException("Internal error: no eligible problem service registered for " + request + "!");
    }
}

