/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency;

import com.dianping.cat.consumer.problem.model.entity.Duration;
import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.problem.model.transform.BaseVisitor;
import com.dianping.cat.helper.SortHelper;
import com.dianping.cat.report.page.dependency.ProblemInfoVisitor;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProblemInfoVisitor
extends BaseVisitor {
    private Map<String, Integer> m_errors = new LinkedHashMap();
    private Date m_start;

    public String buildExceptionInfo() {
        StringBuilder sb = new StringBuilder();
        1 compator = new /* Unavailable Anonymous Inner Class!! */;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (this.m_errors.size() > 0) {
            sb.append("###############################################").append("<br/>");
            sb.append("<span style='color:red'>").append("\u5f02\u5e38\u4fe1\u606f").append("\uff08");
            sb.append(sdf.format(this.m_start)).append("-").append(sdf.format(new Date(this.m_start.getTime() + 3600000L - 1L))).append("\uff09");
            sb.append("</span>").append("<br/>");
        }
        this.m_errors = SortHelper.sortMap((Map)this.m_errors, (Comparator)compator);
        for (Map.Entry error : this.m_errors.entrySet()) {
            sb.append((String)error.getKey()).append(" ").append(error.getValue()).append("<br/>");
        }
        return sb.toString();
    }

    public void visitEntity(Entity entity) {
        String type = entity.getType();
        String state = entity.getStatus();
        if ("error".equals(type)) {
            int count = 0;
            for (Duration duration : entity.getDurations().values()) {
                count += duration.getCount();
            }
            Integer temp = (Integer)this.m_errors.get(state);
            if (temp == null) {
                this.m_errors.put(state, count);
            } else {
                this.m_errors.put(state, temp + count);
            }
        }
    }

    public void visitProblemReport(ProblemReport problemReport) {
        this.m_start = problemReport.getStartTime();
        super.visitProblemReport(problemReport);
    }
}

