/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency;

import com.dianping.cat.consumer.top.model.entity.Domain;
import com.dianping.cat.consumer.top.model.entity.Error;
import com.dianping.cat.consumer.top.model.entity.Segment;
import com.dianping.cat.consumer.top.model.entity.TopReport;
import com.dianping.cat.consumer.top.model.transform.BaseVisitor;
import com.dianping.cat.report.alert.exception.ExceptionRuleConfigManager;
import com.dianping.cat.report.page.dependency.TopMetric;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopMetric
extends BaseVisitor {
    private transient ExceptionRuleConfigManager m_configManager;
    private transient List<String> m_excludedDomains;
    private transient String m_currentDomain;
    private transient Date m_currentStart;
    private transient SimpleDateFormat m_sdf = new SimpleDateFormat("HH:mm");
    private MetricItem m_error;
    private transient long m_currentTime = System.currentTimeMillis();
    private Integer m_currentMinute;
    private Date m_end;
    private Date m_start;

    public TopMetric(int count, int tops, ExceptionRuleConfigManager configManager) {
        this.m_configManager = configManager;
        this.m_error = new MetricItem(this, count, tops);
    }

    public TopMetric(int count, int tops, ExceptionRuleConfigManager configManager, List<String> excludedDomains) {
        this(count, tops, configManager);
        this.m_excludedDomains = excludedDomains;
    }

    public MetricItem getError() {
        return this.m_error;
    }

    public TopMetric setEnd(Date end) {
        this.m_end = end;
        return this;
    }

    public void setError(MetricItem error) {
        this.m_error = error;
    }

    public TopMetric setStart(Date start) {
        this.m_start = start;
        return this;
    }

    public void visitDomain(Domain domain) {
        this.m_currentDomain = domain.getName();
        if (this.m_excludedDomains == null || !this.m_excludedDomains.contains(this.m_currentDomain)) {
            super.visitDomain(domain);
        }
    }

    public void visitError(Error error) {
        String exception = error.getId();
        long count = error.getCount();
        Date minute = new Date(this.m_currentStart.getTime() + (long)this.m_currentMinute.intValue() * 60000L);
        String minuteStr = this.m_sdf.format(minute);
        this.m_error.addError(minuteStr, this.m_currentDomain, exception, count);
        super.visitError(error);
    }

    public void visitSegment(Segment segment) {
        this.m_currentMinute = segment.getId();
        long time = this.m_currentStart.getTime() + (long)this.m_currentMinute.intValue() * 60000L;
        if (this.m_start != null && this.m_end != null && (time > this.m_end.getTime() || time < this.m_start.getTime())) {
            return;
        }
        if (time <= this.m_currentTime + 60000L) {
            Date minute = new Date(this.m_currentStart.getTime() + (long)this.m_currentMinute.intValue() * 60000L);
            String minuteStr = this.m_sdf.format(minute);
            this.m_error.addIndex(minuteStr, this.m_currentDomain, (double)segment.getError());
            super.visitSegment(segment);
        }
    }

    public void visitTopReport(TopReport topReport) {
        this.m_currentStart = topReport.getStartTime();
        super.visitTopReport(topReport);
        this.m_error.buildDisplayResult();
    }

    static /* synthetic */ ExceptionRuleConfigManager access$000(TopMetric x0) {
        return x0.m_configManager;
    }
}

