/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.event.service;

import com.dianping.cat.consumer.event.EventReportMerger;
import com.dianping.cat.consumer.event.model.IEntity;
import com.dianping.cat.consumer.event.model.IVisitor;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.event.model.transform.DefaultSaxParser;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.page.event.service.LocalEventService;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.util.Date;
import java.util.List;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalEventService
extends LocalModelService<EventReport> {
    public static final String ID = "event";
    @Inject
    private ReportBucketManager m_bucketManager;

    public LocalEventService() {
        super(ID);
    }

    private String filterReport(ApiPayload payload, EventReport report) {
        String ipAddress = payload.getIpAddress();
        String type = payload.getType();
        String name = payload.getName();
        EventReportFilter filter = new EventReportFilter(type, name, ipAddress);
        return filter.buildXml((IEntity)report);
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        List reports = super.getReport(period, domain);
        EventReport report = null;
        if (reports != null) {
            report = new EventReport(domain);
            EventReportMerger merger = new EventReportMerger(report);
            for (EventReport tmp : reports) {
                tmp.accept((IVisitor)merger);
            }
        }
        if ((report == null || report.getIps().isEmpty()) && period.isLast()) {
            long startTime = request.getStartTime();
            report = this.getReportFromLocalDisk(startTime, domain);
        }
        return this.filterReport(payload, report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventReport getReportFromLocalDisk(long timestamp, String domain) throws Exception {
        EventReport report = new EventReport(domain);
        EventReportMerger merger = new EventReportMerger(report);
        report.setStartTime(new Date(timestamp));
        report.setEndTime(new Date(timestamp + 3600000L - 1L));
        for (int i = 0; i < 2; ++i) {
            ReportBucket bucket = null;
            try {
                bucket = this.m_bucketManager.getReportBucket(timestamp, ID, i);
                String xml = bucket.findById(domain);
                if (xml != null) {
                    EventReport tmp = DefaultSaxParser.parse((String)xml);
                    tmp.accept((IVisitor)merger);
                    continue;
                }
                report.getDomainNames().addAll(bucket.getIds());
                continue;
            }
            finally {
                if (bucket != null) {
                    this.m_bucketManager.closeBucket(bucket);
                }
            }
        }
        return report;
    }
}

