/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.event.task;

import com.dianping.cat.consumer.event.model.entity.EventName;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.event.model.entity.EventType;
import com.dianping.cat.consumer.event.model.entity.Machine;
import com.dianping.cat.consumer.event.model.entity.Range;
import com.dianping.cat.core.dal.Graph;
import com.dianping.cat.report.task.GraphLine;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventGraphCreator {
    private long[] arrayAdd(long[] src, long[] added) {
        int size = added.length;
        if (src == null) {
            src = new long[size];
        }
        for (int i = 0; i < size; ++i) {
            src[i] = src[i] + added[i];
        }
        return src;
    }

    private String arrayToString(long[] array) {
        StringBuilder sb = new StringBuilder();
        int size = 60;
        for (int i = 0; i < size; ++i) {
            sb.append(array[i]);
            if (i >= 59) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private long[] getFailsCount(List<Range> ranges) {
        long[] value = new long[60];
        for (Range range : ranges) {
            int minute = range.getValue();
            value[minute] = range.getFails();
        }
        return value;
    }

    private long[] getTotalCount(List<Range> ranges) {
        long[] value = new long[60];
        for (Range range : ranges) {
            int minute = range.getValue();
            value[minute] = range.getCount();
        }
        return value;
    }

    public List<Graph> splitReportToGraphs(Date reportPeriod, String domainName, String reportName, EventReport eventReport) {
        Set ips = eventReport.getIps();
        ArrayList<Graph> graphs = new ArrayList<Graph>(ips.size() + 1);
        TreeMap<String, GraphLine> allDetailCache = new TreeMap<String, GraphLine>();
        TreeMap<String, GraphLine> allSummaryCache = new TreeMap<String, GraphLine>();
        Date creationDate = new Date();
        for (String ip : ips) {
            Graph graph = new Graph();
            graph.setIp(ip);
            graph.setDomain(domainName);
            graph.setName(reportName);
            graph.setPeriod(reportPeriod);
            graph.setType(3);
            graph.setCreationDate(creationDate);
            Machine machine = (Machine)eventReport.getMachines().get(ip);
            Map types = machine.getTypes();
            StringBuilder detailBuilder = new StringBuilder();
            StringBuilder summaryBuilder = new StringBuilder();
            for (Map.Entry eventEntry : types.entrySet()) {
                EventType eventType = (EventType)eventEntry.getValue();
                long[] typeCounts = new long[60];
                long[] typeFails = new long[60];
                Map names = eventType.getNames();
                for (Map.Entry nameEntry : names.entrySet()) {
                    EventName eventName = (EventName)nameEntry.getValue();
                    ArrayList ranges = new ArrayList(eventName.getRanges().values());
                    detailBuilder.append(eventType.getId());
                    detailBuilder.append('\t');
                    detailBuilder.append(eventName.getId());
                    detailBuilder.append('\t');
                    long[] totalCount = this.getTotalCount(ranges);
                    detailBuilder.append(this.arrayToString(totalCount));
                    detailBuilder.append('\t');
                    long[] failCount = this.getFailsCount(ranges);
                    detailBuilder.append(this.arrayToString(failCount));
                    detailBuilder.append('\n');
                    String key = eventType.getId() + "\t" + eventName.getId();
                    GraphLine detailLine = (GraphLine)allDetailCache.get(key);
                    if (detailLine == null) {
                        detailLine = new GraphLine();
                        allDetailCache.put(key, detailLine);
                    }
                    detailLine.totalCounts = this.arrayAdd(detailLine.totalCounts, totalCount);
                    detailLine.failCounts = this.arrayAdd(detailLine.failCounts, failCount);
                    typeCounts = this.arrayAdd(typeCounts, totalCount);
                    typeFails = this.arrayAdd(typeFails, failCount);
                }
                String summaryKey = eventType.getId();
                GraphLine summaryLine = (GraphLine)allSummaryCache.get(summaryKey);
                if (summaryLine == null) {
                    summaryLine = new GraphLine();
                    allSummaryCache.put(summaryKey, summaryLine);
                }
                summaryLine.totalCounts = this.arrayAdd(summaryLine.totalCounts, typeCounts);
                summaryLine.failCounts = this.arrayAdd(summaryLine.failCounts, typeFails);
                summaryBuilder.append(eventType.getId());
                summaryBuilder.append('\t');
                summaryBuilder.append(this.arrayToString(typeCounts));
                summaryBuilder.append('\t');
                summaryBuilder.append(this.arrayToString(typeFails));
                summaryBuilder.append('\n');
            }
            graph.setDetailContent(detailBuilder.toString());
            graph.setSummaryContent(summaryBuilder.toString());
            graphs.add(graph);
        }
        Graph allGraph = new Graph();
        allGraph.setIp("all");
        allGraph.setDomain(domainName);
        allGraph.setName(reportName);
        allGraph.setPeriod(reportPeriod);
        allGraph.setType(3);
        allGraph.setCreationDate(creationDate);
        StringBuilder detailSb = new StringBuilder();
        for (Map.Entry entry : allDetailCache.entrySet()) {
            detailSb.append((String)entry.getKey());
            detailSb.append('\t');
            GraphLine value = (GraphLine)entry.getValue();
            detailSb.append(this.arrayToString(value.totalCounts));
            detailSb.append('\t');
            detailSb.append(this.arrayToString(value.failCounts));
            detailSb.append('\t');
            detailSb.append('\n');
        }
        allGraph.setDetailContent(detailSb.toString());
        StringBuilder summarySb = new StringBuilder();
        for (Map.Entry entry : allSummaryCache.entrySet()) {
            summarySb.append((String)entry.getKey());
            summarySb.append('\t');
            GraphLine value = (GraphLine)entry.getValue();
            summarySb.append(this.arrayToString(value.totalCounts));
            summarySb.append('\t');
            summarySb.append(this.arrayToString(value.failCounts));
            summarySb.append('\n');
        }
        allGraph.setSummaryContent(summarySb.toString());
        graphs.add(allGraph);
        return graphs;
    }
}

