/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.event.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.event.EventReportCountFilter;
import com.dianping.cat.consumer.event.model.IVisitor;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.event.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.DailyGraph;
import com.dianping.cat.core.dal.DailyGraphDao;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.Graph;
import com.dianping.cat.core.dal.GraphDao;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.report.page.event.service.EventReportService;
import com.dianping.cat.report.page.event.task.DailyEventGraphCreator;
import com.dianping.cat.report.page.event.task.EventGraphCreator;
import com.dianping.cat.report.page.event.task.EventMerger;
import com.dianping.cat.report.page.event.task.HistoryEventReportMerger;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventReportBuilder
implements TaskBuilder {
    public static final String ID = "event";
    @Inject
    protected GraphDao m_graphDao;
    @Inject
    protected DailyGraphDao m_dailyGraphDao;
    @Inject
    protected EventReportService m_reportService;
    @Inject
    private EventGraphCreator m_eventGraphCreator;
    @Inject
    private EventMerger m_eventMerger;

    public boolean buildDailyTask(String name, String domain, Date period) {
        try {
            EventReport eventReport = this.queryHourlyReportsByDuration(name, domain, period, TaskHelper.tomorrowZero((Date)period));
            this.buildEventDailyGraph(eventReport);
            DailyReport report = new DailyReport();
            report.setCreationDate(new Date());
            report.setDomain(domain);
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(name);
            report.setPeriod(period);
            report.setType(1);
            byte[] binaryContent = DefaultNativeBuilder.build((EventReport)eventReport);
            return this.m_reportService.insertDailyReport(report, binaryContent);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    private void buildEventDailyGraph(EventReport report) {
        DailyEventGraphCreator creator = new DailyEventGraphCreator();
        List graphs = creator.buildDailygraph(report);
        for (DailyGraph graph : graphs) {
            try {
                this.m_dailyGraphDao.insert(graph);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    private List<Graph> buildHourlyGraphs(String name, String domain, Date period) throws DalException {
        long startTime = period.getTime();
        EventReport report = (EventReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 3600000L));
        return this.m_eventGraphCreator.splitReportToGraphs(period, domain, ID, report);
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        try {
            List graphs = this.buildHourlyGraphs(name, domain, period);
            if (graphs != null) {
                for (Graph graph : graphs) {
                    this.m_graphDao.insert(graph);
                }
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        Date end = null;
        end = period.equals(TimeHelper.getCurrentMonth()) ? TimeHelper.getCurrentDay() : TaskHelper.nextMonthStart((Date)period);
        EventReport eventReport = this.queryDailyReportsByDuration(domain, period, end);
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((EventReport)eventReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        Date end = null;
        end = period.equals(TimeHelper.getCurrentWeek()) ? TimeHelper.getCurrentDay() : new Date(period.getTime() + 604800000L);
        EventReport eventReport = this.queryDailyReportsByDuration(domain, period, end);
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((EventReport)eventReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    private EventReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long startTime;
        long endTime = end.getTime();
        double duration = (double)(endTime - startTime) * 1.0 / 8.64E7;
        HistoryEventReportMerger merger = new HistoryEventReportMerger(new EventReport(domain)).setDuration(duration);
        for (startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                EventReport reportModel = (EventReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        EventReport eventReport = merger.getEventReport();
        eventReport.setStartTime(start);
        eventReport.setEndTime(end);
        new EventReportCountFilter().visitEventReport(eventReport);
        return eventReport;
    }

    private EventReport queryHourlyReportsByDuration(String name, String domain, Date start, Date end) throws DalException {
        long startTime;
        Set domainSet = this.m_reportService.queryAllDomainNames(start, end, ID);
        ArrayList<EventReport> reports = new ArrayList<EventReport>();
        long endTime = end.getTime();
        double duration = (double)(endTime - startTime) * 1.0 / 8.64E7;
        for (startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            EventReport report = (EventReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 3600000L));
            reports.add(report);
        }
        return this.m_eventMerger.mergeForDaily(domain, reports, domainSet, duration);
    }
}

