/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.heartbeat;

import com.dianping.cat.report.graph.svg.AbstractGraphPayload;
import java.util.Arrays;

public class HeartbeatSvgBuilder
extends AbstractGraphPayload {
    private String m_idPrefix;
    private int m_index;
    private String[] m_labels;
    private double[] m_values;

    public HeartbeatSvgBuilder(int index, String title, String axisXLabel, String axisYLabel, double[] values) {
        super(title, axisXLabel, axisYLabel);
        this.m_idPrefix = title;
        this.m_index = index;
        this.m_labels = new String[61];
        for (int i = 0; i <= 60; ++i) {
            this.m_labels[i] = String.valueOf(i);
        }
        this.m_values = values == null ? new double[0] : Arrays.copyOf(values, values.length);
    }

    public String getAxisXLabel(int index) {
        if (index % 5 == 0 && index < this.m_labels.length) {
            return this.m_labels[index];
        }
        return "";
    }

    public int getDisplayHeight() {
        return (int)((double)super.getDisplayHeight() * 0.7);
    }

    public int getDisplayWidth() {
        return (int)((double)super.getDisplayWidth() * 0.66);
    }

    public String getIdPrefix() {
        return this.m_idPrefix;
    }

    public int getOffsetX() {
        return this.m_index % 3 * this.getDisplayWidth();
    }

    public int getOffsetY() {
        return this.m_index / 3 * (this.getDisplayHeight() + 20);
    }

    public int getWidth() {
        return super.getWidth() + 120;
    }

    public boolean isStandalone() {
        return false;
    }

    protected double[] loadValues() {
        return this.m_values;
    }
}

