/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.heartbeat;

import com.dianping.cat.consumer.heartbeat.model.entity.Detail;
import com.dianping.cat.consumer.heartbeat.model.entity.Extension;
import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.consumer.heartbeat.model.entity.Machine;
import com.dianping.cat.consumer.heartbeat.model.entity.Period;
import com.dianping.cat.home.heartbeat.entity.Metric;
import com.dianping.cat.report.graph.svg.GraphBuilder;
import com.dianping.cat.report.graph.svg.GraphPayload;
import com.dianping.cat.report.page.heartbeat.HeartbeatSvgBuilder;
import com.dianping.cat.report.page.heartbeat.HeartbeatSvgGraph;
import com.dianping.cat.report.page.heartbeat.config.HeartbeatDisplayPolicyManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeartbeatSvgGraph {
    private HeartbeatDisplayPolicyManager m_manager;
    private static final String DAL = "dal";
    private static final Map<String, Integer> INDEX = new HashMap();
    private static final AtomicInteger INDEX_COUNTER = new AtomicInteger(0);
    private GraphBuilder m_builder;
    private Map<String, Map<String, double[]>> m_extensions = new LinkedHashMap();

    public HeartbeatSvgGraph(GraphBuilder builder, HeartbeatDisplayPolicyManager manager) {
        this.m_builder = builder;
        this.m_manager = manager;
    }

    private void addSortedGroups(Map<String, Map<String, double[]>> tmpExtensions) {
        List orderedGroupNames = this.m_manager.sortGroupNames(this.m_extensions.keySet());
        for (String groupName : orderedGroupNames) {
            Map extensionGroup = (Map)this.m_extensions.get(groupName);
            tmpExtensions.put(groupName, extensionGroup);
        }
    }

    private void buildExtensionGraph(Map<String, ExtensionGroup> graphs, Map.Entry<String, Map<String, double[]>> entry) {
        String title = entry.getKey();
        if (title.equalsIgnoreCase(DAL)) {
            for (Map.Entry<String, double[]> subEntry : entry.getValue().entrySet()) {
                String key = subEntry.getKey();
                int pos = key.lastIndexOf(45);
                if (pos <= 0) continue;
                String db = "Dal " + key.substring(0, pos);
                String subTitle = key.substring(pos + 1);
                ExtensionGroup extensitonGroup = graphs.get(db);
                if (extensitonGroup == null) {
                    extensitonGroup = new ExtensionGroup(this);
                    graphs.put(db, extensitonGroup);
                }
                if (!INDEX.containsKey(subTitle)) {
                    INDEX.put(subTitle, INDEX_COUNTER.getAndIncrement());
                }
                String svg = this.m_builder.build((GraphPayload)new HeartbeatSvgBuilder(((Integer)INDEX.get(subTitle)).intValue(), subTitle, "Minute", "Count", subEntry.getValue()));
                extensitonGroup.getSvgs().put(subTitle, svg);
            }
        } else {
            ExtensionGroup extensitonGroup = graphs.get(title);
            if (extensitonGroup == null) {
                extensitonGroup = new ExtensionGroup(this);
                graphs.put(title, extensitonGroup);
            }
            int i = 0;
            for (Map.Entry<String, double[]> item : entry.getValue().entrySet()) {
                String key = item.getKey();
                Metric metricConfig = this.m_manager.queryMetric(title, key);
                String svgTitle = key;
                String lable = "MB";
                if (metricConfig != null) {
                    String configTitle = metricConfig.getTitle();
                    if (configTitle != null) {
                        svgTitle = configTitle;
                    }
                    lable = metricConfig.getLable();
                }
                String svg = this.m_builder.build((GraphPayload)new HeartbeatSvgBuilder(i++, svgTitle, "Minute", lable, item.getValue()));
                extensitonGroup.getSvgs().put(key, svg);
            }
        }
    }

    private Map<String, Map<String, double[]>> dealWithExtensions() {
        LinkedHashMap<String, Map<String, double[]>> result = new LinkedHashMap<String, Map<String, double[]>>();
        this.addSortedGroups(result);
        for (Map.Entry entry : result.entrySet()) {
            String groupName = (String)entry.getKey();
            Map originMetrics = (Map)entry.getValue();
            List metricNames = this.m_manager.sortMetricNames(groupName, originMetrics.keySet());
            LinkedHashMap<String, double[]> normalizedMetrics = new LinkedHashMap<String, double[]>();
            for (String metricName : metricNames) {
                double[] values = (double[])originMetrics.get(metricName);
                if (this.m_manager.isDelta(groupName, metricName)) {
                    values = this.getAddedCount(values);
                }
                int unit = this.m_manager.queryUnit(groupName, metricName);
                for (int i = 0; i <= 59; ++i) {
                    values[i] = values[i] / (double)unit;
                }
                normalizedMetrics.put(metricName, values);
            }
            entry.setValue(normalizedMetrics);
        }
        return result;
    }

    public HeartbeatSvgGraph display(HeartbeatReport report, String ip) {
        if (report == null) {
            return this;
        }
        Machine machine = (Machine)report.getMachines().get(ip);
        if (machine == null) {
            return this;
        }
        List periods = machine.getPeriods();
        for (int size = periods.size(); size > 0; --size) {
            Period period = (Period)periods.get(size - 1);
            int minute = period.getMinute();
            for (Map.Entry entry : period.getExtensions().entrySet()) {
                String group = (String)entry.getKey();
                LinkedHashMap<String, double[]> groups = (LinkedHashMap<String, double[]>)this.m_extensions.get(group);
                if (groups == null) {
                    groups = new LinkedHashMap<String, double[]>();
                    this.m_extensions.put(group, groups);
                }
                for (Map.Entry detail : ((Extension)entry.getValue()).getDetails().entrySet()) {
                    String key = (String)detail.getKey();
                    double[] doubles = (double[])groups.get(key);
                    if (doubles == null) {
                        doubles = new double[60];
                        groups.put(key, doubles);
                    }
                    doubles[minute] = ((Detail)detail.getValue()).getValue();
                }
            }
        }
        this.m_extensions = this.dealWithExtensions();
        return this;
    }

    private double[] getAddedCount(double[] source) {
        double[] result = new double[60];
        for (int i = 1; i <= 59; ++i) {
            if (!(source[i - 1] > 0.0)) continue;
            double d = source[i] - source[i - 1];
            if (d < 0.0) {
                d = source[i];
            }
            result[i] = d;
        }
        return result;
    }

    public GraphBuilder getBuilder() {
        return this.m_builder;
    }

    public Map<String, ExtensionGroup> getExtensionGraph() {
        LinkedHashMap<String, ExtensionGroup> graphs = new LinkedHashMap<String, ExtensionGroup>();
        for (Map.Entry items : this.m_extensions.entrySet()) {
            this.buildExtensionGraph(graphs, items);
        }
        return graphs;
    }
}

