/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.heartbeat;

import com.dianping.cat.consumer.heartbeat.model.entity.Extension;
import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.consumer.heartbeat.model.entity.Machine;
import com.dianping.cat.consumer.heartbeat.model.entity.Period;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.page.BaseHistoryGraphs;
import com.dianping.cat.report.page.heartbeat.Model;
import com.dianping.cat.report.page.heartbeat.Payload;
import com.dianping.cat.report.page.heartbeat.config.HeartbeatDisplayPolicyManager;
import com.dianping.cat.report.page.heartbeat.service.HeartbeatReportService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryGraphs
extends BaseHistoryGraphs {
    @Inject
    private HeartbeatReportService m_reportService;
    @Inject
    private HeartbeatDisplayPolicyManager m_manager;
    public static final int K = 1024;
    private static final int MINUTE_ONE_DAY = 1440;
    private Set<String> m_extensionMetrics = new HashSet();

    private void addMachineDataToMap(Map<String, double[]> datas, Machine machine) {
        for (Period period : machine.getPeriods()) {
            int minute = period.getMinute();
            this.dealWithExtensions(datas, minute, period);
        }
        this.convertToDeltaArray(datas);
    }

    private Map<String, double[]> buildHeartbeatDatas(HeartbeatReport report, String ip) {
        this.m_extensionMetrics = new HashSet();
        HashMap<String, double[]> datas = new HashMap<String, double[]>();
        Machine machine = report.findMachine(ip);
        if (machine != null) {
            this.addMachineDataToMap(datas, machine);
        }
        return datas;
    }

    private void convertToDeltaArray(Map<String, double[]> datas) {
        this.convertToDeltaArrayPerHour(datas, "TotalStartedThread");
        this.convertToDeltaArrayPerHour(datas, "StartedThread");
        this.convertToDeltaArrayPerHour(datas, "NewGcCount");
        this.convertToDeltaArrayPerHour(datas, "OldGcCount");
        this.convertToDeltaArrayPerHour(datas, "CatMessageSize");
        this.convertToDeltaArrayPerHour(datas, "CatMessageOverflow");
        for (String metric : this.m_extensionMetrics) {
            this.convertToDeltaArrayPerHour(datas, metric);
        }
    }

    private void convertToDeltaArrayPerHour(Map<String, double[]> datas, String metric) {
        double[] values = datas.get(metric);
        if (values != null) {
            double[] targets = new double[1440];
            for (int i = 1; i < 1440; ++i) {
                double delta;
                if (!(values[i - 1] > 0.0) || !((delta = values[i] - values[i - 1]) >= 0.0)) continue;
                targets[i] = delta;
            }
            datas.put(metric, targets);
        }
    }

    private void dealWithExtensions(Map<String, double[]> datas, int minute, Period period) {
        for (String group : period.getExtensions().keySet()) {
            Extension currentExtension = period.findExtension(group);
            for (String metric : currentExtension.getDetails().keySet()) {
                this.m_extensionMetrics.add(metric);
                double value = currentExtension.findDetail(metric).getValue();
                int unit = this.m_manager.queryUnit(group, metric);
                double actualValue = value / (double)unit;
                this.updateMetricArray(datas, minute, metric, actualValue);
            }
        }
    }

    private List<LineChart> getExtensionGraphs(List<String> metrics, Map<String, double[]> graphData, Date start, int size) {
        ArrayList<LineChart> graphs = new ArrayList<LineChart>();
        for (String metric : metrics) {
            graphs.add(this.getGraphItem(metric, metric, start, size, graphData));
        }
        return graphs;
    }

    private LineChart getGraphItem(String title, String key, Date start, int size, Map<String, double[]> graphData) {
        LineChart item = new LineChart();
        item.setStart(start);
        item.setSize(size);
        item.setTitle(title);
        item.addSubTitle(title);
        item.setStep(60000L);
        double[] activeThread = graphData.get(key);
        item.addValue(activeThread);
        return item;
    }

    private Set<String> queryMetricNames(HeartbeatReport report, String groupName) {
        HashSet<String> result = new HashSet<String>();
        for (Machine machine : report.getMachines().values()) {
            for (Period period : machine.getPeriods()) {
                Extension extension = period.findExtension(groupName);
                if (extension == null) continue;
                result.addAll(extension.getDetails().keySet());
            }
        }
        return result;
    }

    public void showHeartBeatGraph(Model model, Payload payload) {
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        int size = (int)((end.getTime() - start.getTime()) / 3600000L * 60L);
        HeartbeatReport report = (HeartbeatReport)this.m_reportService.queryReport(payload.getDomain(), start, end);
        Map graphData = this.buildHeartbeatDatas(report, payload.getIpAddress());
        String groupName = payload.getExtensionType();
        List metrics = this.m_manager.sortMetricNames(groupName, this.queryMetricNames(report, groupName));
        List graphs = this.getExtensionGraphs(metrics, graphData, start, size);
        model.setExtensionCount(metrics.size());
        model.setExtensionHistoryGraphs(new JsonBuilder().toJson((Object)graphs));
    }

    private void updateMetricArray(Map<String, double[]> datas, int minute, String metricName, double value) {
        double[] values = datas.get(metricName);
        if (values == null) {
            values = new double[1440];
            datas.put(metricName, values);
        }
        values[minute] = value;
    }
}

