/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.heartbeat.config;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.heartbeat.entity.Group;
import com.dianping.cat.home.heartbeat.entity.HeartbeatDisplayPolicy;
import com.dianping.cat.home.heartbeat.entity.Metric;
import com.dianping.cat.home.heartbeat.transform.DefaultSaxParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeartbeatDisplayPolicyManager
implements Initializable {
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private static final int K = 1024;
    private int m_configId;
    private HeartbeatDisplayPolicy m_config;
    private static final String CONFIG_NAME = "heartbeat-display-policy";

    public HeartbeatDisplayPolicy getHeartbeatDisplayPolicy() {
        return this.m_config;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new HeartbeatDisplayPolicy();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean isDelta(String groupName, String metricName) {
        Metric metric;
        Group group = this.m_config.findGroup(groupName);
        if (group != null && (metric = group.findMetric(metricName)) != null) {
            return metric.isDelta();
        }
        return false;
    }

    public Metric queryMetric(String groupName, String metricName) {
        Metric metric;
        Group group = this.m_config.findGroup(groupName);
        if (group != null && (metric = group.findMetric(metricName)) != null) {
            return metric;
        }
        return null;
    }

    public List<String> queryAlertMetrics() {
        ArrayList<String> metrics = new ArrayList<String>();
        for (Group group : this.m_config.getGroups().values()) {
            String groupId = group.getId();
            for (Metric metric : group.getMetrics().values()) {
                if (!metric.isAlert()) continue;
                metrics.add(groupId + ":" + metric.getId());
            }
        }
        return metrics;
    }

    public int queryUnit(String groupName, String metricName) {
        Metric metric;
        Group group = this.m_config.findGroup(groupName);
        if (group != null && (metric = group.findMetric(metricName)) != null) {
            String metricUnit = metric.getUnit();
            if ("K".equals(metricUnit)) {
                return 1024;
            }
            if ("M".equals(metricUnit)) {
                return 0x100000;
            }
            if ("G".equals(metricUnit)) {
                return 0x40000000;
            }
            return Integer.parseInt(metricUnit);
        }
        return 1;
    }

    public List<String> sortGroupNames(List<String> originGroupNames) {
        ArrayList groups = new ArrayList();
        for (Map.Entry entry : this.m_config.getGroups().entrySet()) {
            if (!originGroupNames.contains(entry.getKey())) continue;
            groups.add(entry.getValue());
        }
        Collections.sort(groups, new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<String> result = new ArrayList<String>();
        for (Group group : groups) {
            result.add(group.getId());
        }
        for (String originGroupName : originGroupNames) {
            if (result.contains(originGroupName)) continue;
            result.add(originGroupName);
        }
        return result;
    }

    public List<String> sortGroupNames(Set<String> originGroupNameSet) {
        return this.sortGroupNames(new ArrayList<String>(originGroupNameSet));
    }

    public List<String> sortMetricNames(String groupName, List<String> originMetricNames) {
        Group group = this.m_config.findGroup(groupName);
        ArrayList<String> result = new ArrayList<String>();
        if (group != null) {
            ArrayList list = new ArrayList();
            for (Map.Entry entry : group.getMetrics().entrySet()) {
                if (!originMetricNames.contains(entry.getKey())) continue;
                list.add(entry.getValue());
            }
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
            for (Metric metric : list) {
                result.add(metric.getId());
            }
        }
        for (String originMetricName : originMetricNames) {
            if (result.contains(originMetricName)) continue;
            result.add(originMetricName);
        }
        return result;
    }

    public List<String> sortMetricNames(String groupName, Set<String> originMetricNames) {
        return this.sortMetricNames(groupName, new ArrayList<String>(originMetricNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        HeartbeatDisplayPolicyManager heartbeatDisplayPolicyManager = this;
        synchronized (heartbeatDisplayPolicyManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_config.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

