/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.heartbeat.service;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.heartbeat.HeartbeatReportMerger;
import com.dianping.cat.consumer.heartbeat.model.IVisitor;
import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.consumer.heartbeat.model.transform.DefaultNativeParser;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.report.page.heartbeat.service.HeartbeatReportService;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeartbeatReportService
extends AbstractReportService<HeartbeatReport> {
    public HeartbeatReport makeReport(String domain, Date start, Date end) {
        HeartbeatReport report = new HeartbeatReport(domain);
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    public HeartbeatReport queryDailyReport(String domain, Date start, Date end) {
        HeartbeatReportMerger merger = new HeartbeatReportMerger(new HeartbeatReport(domain));
        long endTime = end.getTime();
        String name = "heartbeat";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod(domain, name, new Date(startTime), DailyReportEntity.READSET_FULL);
                HeartbeatReport reportModel = this.queryFromDailyBinary(report.getId(), domain);
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (DalNotFoundException report) {
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        HeartbeatReport heartbeatReport = merger.getHeartbeatReport();
        heartbeatReport.setStartTime(start);
        heartbeatReport.setEndTime(new Date(end.getTime() - 1L));
        Set domains = this.queryAllDomainNames(start, end, "heartbeat");
        heartbeatReport.getDomainNames().addAll(domains);
        new HeartbeatConvertor().visitHeartbeatReport(heartbeatReport);
        return heartbeatReport;
    }

    private HeartbeatReport queryFromDailyBinary(int id, String domain) throws DalException {
        DailyReportContent content = this.m_dailyReportContentDao.findByPK(id, DailyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new HeartbeatReport(domain);
    }

    private HeartbeatReport queryFromHourlyBinary(int id, String domain) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, HourlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new HeartbeatReport(domain);
    }

    public HeartbeatReport queryHourlyReport(String domain, Date start, Date end) {
        HeartbeatReportMerger merger = new HeartbeatReportMerger(new HeartbeatReport(domain));
        long endTime = end.getTime();
        String name = "heartbeat";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            List reports = null;
            try {
                reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(new Date(startTime), domain, name, HourlyReportEntity.READSET_FULL);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
            if (reports == null) continue;
            for (HourlyReport report : reports) {
                try {
                    HeartbeatReport reportModel = this.queryFromHourlyBinary(report.getId(), domain);
                    reportModel.accept((IVisitor)merger);
                }
                catch (DalNotFoundException reportModel) {
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        HeartbeatReport heartbeatReport = merger.getHeartbeatReport();
        heartbeatReport.setStartTime(start);
        heartbeatReport.setEndTime(new Date(end.getTime() - 1L));
        Set domains = this.queryAllDomainNames(start, end, "heartbeat");
        heartbeatReport.getDomainNames().addAll(domains);
        new HeartbeatConvertor().visitHeartbeatReport(heartbeatReport);
        return heartbeatReport;
    }

    public HeartbeatReport queryMonthlyReport(String domain, Date start) {
        throw new RuntimeException("Heartbeat report don't support monthly report");
    }

    public HeartbeatReport queryWeeklyReport(String domain, Date start) {
        throw new RuntimeException("Heartbeat report don't support weekly report");
    }
}

