/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.heartbeat.task;

import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.consumer.heartbeat.model.entity.Machine;
import com.dianping.cat.consumer.heartbeat.model.entity.Period;
import com.dianping.cat.consumer.heartbeat.model.transform.DefaultMerger;

public class HeartbeatDailyMerger
extends DefaultMerger {
    private long m_currentDay;
    private int m_hourIndex;

    public HeartbeatDailyMerger(HeartbeatReport heartbeatReport, long currentDay) {
        super(heartbeatReport);
        this.m_currentDay = currentDay;
    }

    public void visitHeartbeatReport(HeartbeatReport from) {
        long start = from.getStartTime().getTime();
        this.m_hourIndex = (int)((start - this.m_currentDay) / 3600000L);
        super.visitHeartbeatReport(from);
    }

    protected void visitMachineChildren(Machine to, Machine from) {
        for (Period source : from.getPeriods()) {
            int minute = source.getMinute();
            source.setMinute(60 * this.m_hourIndex + minute);
        }
        super.visitMachineChildren(to, from);
    }
}

