/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.heartbeat.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.heartbeat.model.IVisitor;
import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.consumer.heartbeat.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.GraphDao;
import com.dianping.cat.report.page.heartbeat.service.HeartbeatReportService;
import com.dianping.cat.report.page.heartbeat.task.HeartbeatDailyMerger;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import java.util.Date;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;

public class HeartbeatReportBuilder
implements TaskBuilder {
    public static final String ID = "heartbeat";
    @Inject
    protected GraphDao m_graphDao;
    @Inject
    protected HeartbeatReportService m_reportService;

    public boolean buildDailyTask(String name, String domain, Date period) {
        try {
            Date end = TaskHelper.tomorrowZero((Date)period);
            HeartbeatReport heartbeatReport = this.queryDailyHeartbeatReport(name, domain, period, end);
            DailyReport report = new DailyReport();
            report.setCreationDate(new Date());
            report.setDomain(domain);
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(name);
            report.setPeriod(period);
            report.setType(1);
            byte[] binaryContent = DefaultNativeBuilder.build((HeartbeatReport)heartbeatReport);
            return this.m_reportService.insertDailyReport(report, binaryContent);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new UnsupportedOperationException("no hourly report builder for heartbeat!");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new UnsupportedOperationException("no month report builder for heartbeat!");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new UnsupportedOperationException("no weekly report builder for heartbeat!");
    }

    private HeartbeatReport queryDailyHeartbeatReport(String name, String domain, Date start, Date end) {
        Set domains = this.m_reportService.queryAllDomainNames(start, end, ID);
        HeartbeatDailyMerger merger = new HeartbeatDailyMerger(new HeartbeatReport(domain), start.getTime());
        long endTime = end.getTime();
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            HeartbeatReport report = (HeartbeatReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 3600000L));
            report.accept((IVisitor)merger);
        }
        HeartbeatReport heartbeatReport = merger.getHeartbeatReport();
        heartbeatReport.setStartTime(start);
        heartbeatReport.setEndTime(new Date(end.getTime() - 1L));
        heartbeatReport.getDomainNames().addAll(domains);
        return heartbeatReport;
    }
}

