/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.logview.service;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.spi.MessageCodec;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.storage.MessageBucketManager;
import com.dianping.cat.report.service.BaseHistoricalModelService;
import com.dianping.cat.report.service.ModelRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricalMessageService
extends BaseHistoricalModelService<String> {
    @Inject(value={"hdfs"})
    private MessageBucketManager m_hdfsBucketManager;
    @Inject(value={"html"})
    private MessageCodec m_html;
    @Inject(value={"waterfall"})
    private MessageCodec m_waterfall;

    public HistoricalMessageService() {
        super("logview");
    }

    protected String buildModel(ModelRequest request) throws Exception {
        String messageId = request.getProperty("messageId");
        Cat.logEvent((String)"LoadMessage", (String)"messageTree", (String)"0", (String)messageId);
        MessageTree tree = this.m_hdfsBucketManager.loadMessage(messageId);
        if (tree != null) {
            return this.toString(request, tree);
        }
        return null;
    }

    public boolean isEligable(ModelRequest request) {
        boolean eligibale = request.getPeriod().isHistorical();
        if (eligibale) {
            String messageId = request.getProperty("messageId");
            MessageId id = MessageId.parse((String)messageId);
            return id.getVersion() == 2;
        }
        return eligibale;
    }

    protected String toString(ModelRequest request, MessageTree tree) {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(8192);
        if (tree.getMessage() instanceof Transaction && request.getProperty("waterfall", "false").equals("true")) {
            this.m_waterfall.encode(tree, buf);
        } else {
            this.m_html.encode(tree, buf);
        }
        try {
            buf.readInt();
            return buf.toString(Charset.forName("utf-8"));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

