/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.logview.service;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.spi.MessageCodec;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.storage.MessageBucketManager;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalMessageService
extends LocalModelService<String>
implements ModelService<String> {
    public static final String ID = "dump";
    @Inject(value={"local"})
    private MessageBucketManager m_bucketManager;
    @Inject(value={"html"})
    private MessageCodec m_html;
    @Inject(value={"waterfall"})
    private MessageCodec m_waterfall;

    public LocalMessageService() {
        super("logview");
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        String messageId = payload.getMessageId();
        boolean waterfull = payload.isWaterfall();
        MessageTree tree = this.m_bucketManager.loadMessage(messageId);
        if (tree != null) {
            ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(8192);
            if (tree.getMessage() instanceof Transaction && waterfull) {
                this.m_waterfall.encode(tree, buf);
            } else {
                this.m_html.encode(tree, buf);
            }
            try {
                buf.readInt();
                return buf.toString(Charset.forName("utf-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelResponse<String> invoke(ModelRequest request) {
        ModelResponse response = new ModelResponse();
        Transaction t = Cat.newTransaction((String)"ModelService", (String)this.getClass().getSimpleName());
        try {
            ModelPeriod period = request.getPeriod();
            String domain = request.getDomain();
            ApiPayload payload = new ApiPayload();
            payload.setMessageId(request.getProperty("messageId"));
            payload.setWaterfall(Boolean.valueOf(request.getProperty("waterfall", "false")).booleanValue());
            String report = this.getReport(request, period, domain, payload);
            response.setModel((Object)report);
            t.addData("period", (Object)period);
            t.addData("domain", (Object)domain);
            t.setStatus("0");
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            t.setStatus((Throwable)e);
            response.setException(e);
        }
        finally {
            t.complete();
        }
        return response;
    }

    public boolean isEligable(ModelRequest request) {
        if (this.m_manager.isHdfsOn()) {
            boolean eligibale = request.getPeriod().isCurrent();
            if (eligibale) {
                String messageId = request.getProperty("messageId");
                MessageId id = MessageId.parse((String)messageId);
                return id.getVersion() == 2;
            }
            return eligibale;
        }
        return true;
    }
}

