/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.logview.service;

import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.service.BaseRemoteModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.unidal.helper.Files;
import org.unidal.helper.Urls;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteLogViewService
extends BaseRemoteModelService<String> {
    private ServerConfigManager m_manager;

    public RemoteLogViewService() {
        super("logview");
    }

    protected String buildModel(String content) throws SAXException, IOException {
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelResponse<String> invoke(ModelRequest request) {
        ModelResponse response = new ModelResponse();
        Transaction t = this.newTransaction("ModelService", this.getClass().getSimpleName());
        try {
            URL url = this.buildUrl(request);
            t.addData(url.toString());
            InputStream in = Urls.forIO().connectTimeout(1000).readTimeout(5000).openStream(url.toExternalForm());
            GZIPInputStream gzip = new GZIPInputStream(in);
            String xml = Files.forIO().readFrom((InputStream)gzip, "utf-8");
            int len = xml == null ? 0 : xml.length();
            t.addData("length", (Object)len);
            if (len > 0) {
                String report = this.buildModel(xml);
                response.setModel((Object)report);
                t.addData("hit", (Object)"true");
            }
            t.setStatus("0");
        }
        catch (Exception e) {
            t.setStatus("0");
        }
        finally {
            t.complete();
        }
        return response;
    }

    public boolean isEligable(ModelRequest request) {
        if (this.m_manager.isHdfsOn()) {
            ModelPeriod period = request.getPeriod();
            if (period.isHistorical()) {
                long current;
                long currentHour;
                long time = Long.parseLong(request.getProperty("timestamp"));
                return time == (currentHour = (current = System.currentTimeMillis()) - current % 3600000L) - 0x6DDD00L;
            }
            return true;
        }
        return true;
    }

    public void setManager(ServerConfigManager manager) {
        this.m_manager = manager;
    }
}

