/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.matrix.service;

import com.dianping.cat.consumer.matrix.MatrixReportMerger;
import com.dianping.cat.consumer.matrix.model.IEntity;
import com.dianping.cat.consumer.matrix.model.IVisitor;
import com.dianping.cat.consumer.matrix.model.entity.MatrixReport;
import com.dianping.cat.consumer.matrix.model.transform.DefaultSaxParser;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.page.matrix.service.LocalMatrixService;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.util.Date;
import java.util.List;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalMatrixService
extends LocalModelService<MatrixReport> {
    public static final String ID = "matrix";
    @Inject
    private ReportBucketManager m_bucketManager;

    public LocalMatrixService() {
        super(ID);
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        List reports = super.getReport(period, domain);
        MatrixReport report = null;
        if (reports != null) {
            report = new MatrixReport(domain);
            MatrixReportMerger merger = new MatrixReportMerger(report);
            for (MatrixReport tmp : reports) {
                tmp.accept((IVisitor)merger);
            }
        }
        if ((report == null || report.getDomainNames().isEmpty()) && period.isLast()) {
            long startTime = request.getStartTime();
            report = this.getReportFromLocalDisk(startTime, domain);
        }
        return new MatrixReportFilter().buildXml((IEntity)report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatrixReport getReportFromLocalDisk(long timestamp, String domain) throws Exception {
        MatrixReport report = new MatrixReport(domain);
        MatrixReportMerger merger = new MatrixReportMerger(report);
        report.setStartTime(new Date(timestamp));
        report.setEndTime(new Date(timestamp + 3600000L - 1L));
        for (int i = 0; i < 2; ++i) {
            ReportBucket bucket = null;
            try {
                bucket = this.m_bucketManager.getReportBucket(timestamp, ID, i);
                String xml = bucket.findById(domain);
                if (xml != null) {
                    MatrixReport tmp = DefaultSaxParser.parse((String)xml);
                    tmp.accept((IVisitor)merger);
                    continue;
                }
                report.getDomainNames().addAll(bucket.getIds());
                continue;
            }
            finally {
                if (bucket != null) {
                    this.m_bucketManager.closeBucket(bucket);
                }
            }
        }
        return report;
    }
}

