/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.matrix.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.matrix.MatrixReportFilter;
import com.dianping.cat.consumer.matrix.MatrixReportMerger;
import com.dianping.cat.consumer.matrix.model.IVisitor;
import com.dianping.cat.consumer.matrix.model.entity.MatrixReport;
import com.dianping.cat.consumer.matrix.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.report.page.matrix.service.MatrixReportService;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import java.util.Date;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;

public class MatrixReportBuilder
implements TaskBuilder {
    public static final String ID = "matrix";
    @Inject
    protected MatrixReportService m_reportService;

    public boolean buildDailyTask(String name, String domain, Date period) {
        MatrixReport matrixReport = this.queryHourlyReportByDuration(name, domain, period, TaskHelper.tomorrowZero((Date)period));
        DailyReport report = new DailyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((MatrixReport)matrixReport);
        return this.m_reportService.insertDailyReport(report, binaryContent);
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("Matrix report don't support hourly report!");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        MatrixReport matrixReport = this.queryDailyReportsByDuration(domain, period, TaskHelper.nextMonthStart((Date)period));
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((MatrixReport)matrixReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        MatrixReport matrixReport = this.queryDailyReportsByDuration(domain, period, new Date(period.getTime() + 604800000L));
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((MatrixReport)matrixReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    private MatrixReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long endTime = end.getTime();
        MatrixReportMerger merger = new MatrixReportMerger(new MatrixReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                MatrixReport reportModel = (MatrixReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        MatrixReport matrixReport = merger.getMatrixReport();
        new MatrixReportFilter().visitMatrixReport(matrixReport);
        matrixReport.setStartTime(start);
        matrixReport.setEndTime(end);
        return matrixReport;
    }

    private MatrixReport queryHourlyReportByDuration(String name, String domain, Date start, Date end) {
        Set domainSet = this.m_reportService.queryAllDomainNames(start, end, ID);
        long endTime = end.getTime();
        MatrixReportMerger merger = new MatrixReportMerger(new MatrixReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            Date date = new Date(startTime);
            MatrixReport reportModel = (MatrixReport)this.m_reportService.queryReport(domain, date, new Date(date.getTime() + 3600000L));
            reportModel.accept((IVisitor)merger);
        }
        MatrixReport matrixReport = merger.getMatrixReport();
        new MatrixReportFilter().visitMatrixReport(matrixReport);
        matrixReport.getDomainNames().addAll(domainSet);
        matrixReport.setStartTime(start);
        matrixReport.setEndTime(end);
        return matrixReport;
    }
}

