/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.metric;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.company.model.entity.ProductLine;
import com.dianping.cat.consumer.config.ProductLineConfig;
import com.dianping.cat.consumer.metric.config.entity.MetricItemConfig;
import com.dianping.cat.consumer.metric.config.entity.Tag;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.core.dal.Project;
import com.dianping.cat.report.alert.AlertInfo;
import com.dianping.cat.report.alert.MetricType;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.metric.AbstractGraphCreator;
import com.dianping.cat.service.ProjectService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphCreator
extends AbstractGraphCreator {
    @Inject
    private ProjectService m_projectService;

    private Map<String, LineChart> buildChartData(String productLine, Map<String, double[]> datas, Date startDate, Date endDate, Map<String, double[]> dataWithOutFutures) {
        LinkedHashMap<String, LineChart> charts = new LinkedHashMap<String, LineChart>();
        List alertKeys = this.m_alertInfo.queryLastestAlarmKey(5);
        int step = this.m_dataExtractor.getStep();
        for (Map.Entry<String, double[]> entry : dataWithOutFutures.entrySet()) {
            String key = entry.getKey();
            double[] value = entry.getValue();
            LineChart lineChart = new LineChart();
            this.buildLineChartTitle(alertKeys, lineChart, key);
            lineChart.setStart(startDate);
            lineChart.setSize(value.length);
            lineChart.setStep((long)step * 60000L);
            double[] baselines = this.queryBaseline(key, startDate, endDate);
            Map all = this.convertToMap(datas.get(key), startDate, 1);
            Map current = this.convertToMap(dataWithOutFutures.get(key), startDate, step);
            this.addLastMinuteData(current, all, this.m_lastMinute, endDate);
            lineChart.add("\u5f53\u524d\u503c", current);
            lineChart.add("\u57fa\u7ebf\u503c", this.convertToMap(this.m_dataExtractor.extract(baselines), startDate, step));
            charts.put(key, lineChart);
        }
        return charts;
    }

    public Map<String, LineChart> buildChartsByProductLine(String productLine, Date startDate, Date endDate) {
        Map oldCurrentValues = this.prepareAllData(productLine, startDate, endDate);
        Map allCurrentValues = this.m_dataExtractor.extract(oldCurrentValues);
        Map dataWithOutFutures = this.removeFutureData(endDate, allCurrentValues);
        return this.buildChartData(productLine, oldCurrentValues, startDate, endDate, dataWithOutFutures);
    }

    protected String buildContactInfo(String domainName) {
        try {
            Project project = this.m_projectService.findByDomain(domainName);
            if (project != null) {
                String owners = project.getOwner();
                String phones = project.getPhone();
                StringBuilder builder = new StringBuilder();
                builder.append("[\u9879\u76ee: ").append(domainName);
                if (!StringUtils.isEmpty((String)owners)) {
                    builder.append(" \u8d1f\u8d23\u4eba: ").append(owners);
                }
                if (!StringUtils.isEmpty((String)phones)) {
                    builder.append(" \u624b\u673a: ").append(phones).append(" ]");
                }
                return builder.toString();
            }
        }
        catch (Exception ex) {
            Cat.logError((String)("build contact info error for doamin: " + domainName), (Throwable)ex);
        }
        return null;
    }

    public Map<String, LineChart> buildDashboardByTag(Date start, Date end, String tag) {
        LinkedHashMap<String, LineChart> result = new LinkedHashMap<String, LineChart>();
        List metricItemConfigs = this.m_metricConfigManager.queryMetricItemConfigs(tag);
        Collection productLines = this.m_productLineConfigManager.queryAllProductLines().values();
        LinkedHashMap allCharts = new LinkedHashMap();
        for (ProductLine productLine : productLines) {
            if (!this.isProductLineInTag(productLine.getId(), metricItemConfigs)) continue;
            allCharts.putAll(this.buildChartsByProductLine(productLine.getId(), start, end));
        }
        for (MetricItemConfig metric : metricItemConfigs) {
            String domain = metric.getDomain();
            String metricType = metric.getType();
            String type = metricType.equalsIgnoreCase("metric") ? "Metric" : metricType;
            String key = metric.getMetricKey();
            for (Tag metricTag : metric.getTags()) {
                if (!tag.equals(metricTag.getName())) continue;
                String tagType = metricTag.getType();
                String id = this.m_metricConfigManager.buildMetricKey(domain, type, key) + ":" + tagType;
                this.put(allCharts, result, id);
            }
        }
        return result;
    }

    private Map<String, double[]> buildGraphData(MetricReport metricReport, List<MetricItemConfig> metricConfigs) {
        Map datas = this.m_pruductDataFetcher.buildGraphData(metricReport);
        LinkedHashMap<String, double[]> values = new LinkedHashMap<String, double[]>();
        for (MetricItemConfig config : metricConfigs) {
            String key = config.getId();
            if (config.getShowAvg()) {
                String avgKey = key + ":" + MetricType.AVG.name();
                this.putKey(datas, values, avgKey);
            }
            if (config.getShowCount()) {
                String countKey = key + ":" + MetricType.COUNT.name();
                this.putKey(datas, values, countKey);
            }
            if (!config.getShowSum()) continue;
            String sumKey = key + ":" + MetricType.SUM.name();
            this.putKey(datas, values, sumKey);
        }
        return values;
    }

    private void buildLineChartTitle(List<AlertInfo.AlertMetric> alertKeys, LineChart chart, String key) {
        int index = key.lastIndexOf(":");
        String metricId = key.substring(0, index);
        String type = key.substring(index + 1);
        MetricItemConfig config = this.m_metricConfigManager.queryMetricItemConfig(metricId);
        if (config != null) {
            String des = this.queryMetricItemDes(type);
            String title = config.getTitle() + des;
            chart.setTitle(title);
            chart.setId(metricId + ":" + type);
            if (this.containMetric(alertKeys, metricId)) {
                String contactInfo = this.buildContactInfo(this.extractDomain(key));
                chart.setHtmlTitle("<span style='color:red'>" + title + "<br><small>" + contactInfo + "</small></span>");
            } else {
                chart.setHtmlTitle(title);
            }
        }
    }

    private boolean containMetric(List<AlertInfo.AlertMetric> alertKeys, String metricId) {
        for (AlertInfo.AlertMetric alertMetric : alertKeys) {
            if (!alertMetric.getMetricId().equals(metricId)) continue;
            return true;
        }
        return false;
    }

    private String extractDomain(String metricKey) {
        try {
            return metricKey.split(":")[0];
        }
        catch (Exception ex) {
            Cat.logError((String)("extract domain error:" + metricKey), (Throwable)ex);
            return null;
        }
    }

    private boolean isProductLineInTag(String productLine, List<MetricItemConfig> configs) {
        List domains = this.m_productLineConfigManager.queryDomainsByProductLine(productLine, ProductLineConfig.METRIC);
        List metricConfig = this.m_metricConfigManager.queryMetricItemConfigs((Collection)domains);
        for (MetricItemConfig metric : configs) {
            String domain = metric.getDomain();
            String type = metric.getType();
            String key = metric.getMetricKey();
            for (MetricItemConfig item : metricConfig) {
                if (!item.getDomain().equalsIgnoreCase(domain) || !item.getType().equalsIgnoreCase(type) || !item.getMetricKey().equalsIgnoreCase(key)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, double[]> prepareAllData(String productLine, Date startDate, Date endDate) {
        long start;
        long end = endDate.getTime();
        int totalSize = (int)((end - start) / 60000L);
        LinkedHashMap<String, double[]> oldCurrentValues = new LinkedHashMap<String, double[]>();
        int index = 0;
        for (start = startDate.getTime(); start < end; start += 3600000L) {
            Map currentValues = this.queryMetricValueByDate(productLine, start);
            this.mergeMap(oldCurrentValues, currentValues, totalSize, index);
            ++index;
        }
        return oldCurrentValues;
    }

    private String queryMetricItemDes(String type) {
        String des = "";
        if (MetricType.AVG.name().equals(type)) {
            des = "(\u5e73\u5747)";
        } else if (MetricType.SUM.name().equals(type)) {
            des = "(\u603b\u548c)";
        } else if (MetricType.COUNT.name().equals(type)) {
            des = "(\u6b21\u6570)";
        }
        return des;
    }

    private Map<String, double[]> queryMetricValueByDate(String productLine, long start) {
        MetricReport metricReport = this.m_metricReportService.queryMetricReport(productLine, new Date(start));
        List domains = this.m_productLineConfigManager.queryDomainsByProductLine(productLine, ProductLineConfig.METRIC);
        List metricConfigs = this.m_metricConfigManager.queryMetricItemConfigs((Collection)domains);
        Collections.sort(metricConfigs, new /* Unavailable Anonymous Inner Class!! */);
        Map currentValues = this.buildGraphData(metricReport, metricConfigs);
        double sum = 0.0;
        for (Map.Entry entry : currentValues.entrySet()) {
            double[] value = (double[])entry.getValue();
            int length = value.length;
            for (int i = 0; i < length; ++i) {
                sum += value[i];
            }
        }
        return currentValues;
    }
}

